<?php
class Stocks extends CI_Model {




		
		public function get_all_active_stock()
		{
		$this->db->select('dc_record.dc_no,SUM(dc_record.qty) AS qty,purchase_order_materials_details.material_id,purchase_order_materials_details.product_id,purchase_order_materials_details.unit');$this->db->from('dc_record');
			$this->db->join('purchase_order_materials_details', 'dc_record.po_id = purchase_order_materials_details.po_id', 'inner');
		$this->db->where('dc_record.qc_status',1 );
		$this->db->group_by('purchase_order_materials_details.material_id');
		$sql = $this->db->get();
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}


			public function get_raw_material_mixing()
		{
		$this->db->select('dc_record.qty,dc_record.id,dc_record.grn_no,purchase_order_materials_details.material_id,purchase_order_materials_details.product_id,purchase_order_materials_details.unit');$this->db->from('dc_record');
			$this->db->join('purchase_order_materials_details', 'dc_record.po_id = purchase_order_materials_details.po_id', 'inner');
		$this->db->where('dc_record.qc_status',1 );
		//$this->db->group_by('purchase_order_materials_details.po_id');
		$sql = $this->db->get();
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

	public function get_products_fg(){
		$this->db->select('products.id,products.name');  
		  
		$this->db->from('products');
		
		$this->db->where('product_type',5);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function get_products_printed(){
			$this->db->select('products.id,products.name');  
			  
			$this->db->from('products');
			
			$this->db->where('product_type',2);
			$sql = $this->db->get();
	
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			
			public function get_products_assembled(){
				$this->db->select('products.id,products.name');  
				  
				$this->db->from('products');
				
				$this->db->where('product_type',3);
				$sql = $this->db->get();
		
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}


				public function get_products_sealed(){
					$this->db->select('products.id,products.name');  
					  
					$this->db->from('products');
					
					$this->db->where('product_type',4);
					$sql = $this->db->get();
			
					if($sql->num_rows() >0)
					{return $sql->result_array();
					}else
					{return false;}
					}


	public function get_products_semi_production(){
		$this->db->select('production_machine_remarks.so_id,production_machine_remarks.machine');  
		  
		$this->db->from('production_machine_remarks');
		
		$this->db->where('status',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_products_semi(){
		$this->db->select('products.id,products.name');  
		  
		$this->db->from('products');
		
		$this->db->where('product_type !=',5);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_products_semi_production_product(){
		$this->db->select('production_plan.id,production_plan.product_name');  
		  
		$this->db->from('production_plan');
		
		$this->db->group_by('production_plan.product_name');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		

		public function check_so_po_boms($so_id){
		$this->db->select('so_po_boms.production_plan');  
		  
		$this->db->from('so_po_boms');
		
		$this->db->where('so_id',$so_id);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		public function check_machine_status($machine){
			$this->db->select('status');  
			  
			$this->db->from('prinnting_line_machine');
			
			$this->db->where('machine',$machine);
			$this->db->where('status',2);
			$sql = $this->db->get();
	
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			

			public function check_line_status($line){
				$this->db->select('status');  
				  
				$this->db->from('assembled_line_assign');
				
				$this->db->where('line',$line);
				$this->db->where('status',2);
				$sql = $this->db->get();
		
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}

			
			public function line_assembled_description(){
				$this->db->select('*');  
				  
				$this->db->from('assembled_line');
				
			
				$sql = $this->db->get();
		
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}


			public function transform_data_printing($id){
				$this->db->select('*');  
				  
				$this->db->from('prinnting_line_machine');
				
				$this->db->where('id',$id);
				$this->db->where('status',2);
				$sql = $this->db->get();
		
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}

				

				public function transform_data_sealing($id){
					$this->db->select('*');  
					  
					$this->db->from('sealing_line_machine');
					
					$this->db->where('id',$id);
					$this->db->where('status',2);
					$sql = $this->db->get();
			
					if($sql->num_rows() >0)
					{return $sql->result_array();
					}else
					{return false;}
					}

					
					public function transform_data_fg($id){
						$this->db->select('*');  
						  
						$this->db->from('transform_logs');
						
						$this->db->where('id',$id);
						$this->db->where('type',5);
						$sql = $this->db->get();
				
						if($sql->num_rows() >0)
						{return $sql->result_array();
						}else
						{return false;}
						}
				

				public function transform_data_assembled($id){
					$this->db->select('*');  
					  
					$this->db->from('assembled_line_assign');
					
					$this->db->where('batch_no',$id);
					$this->db->where('status',2);
					$this->db->group_by('batch');
					$sql = $this->db->get();
			
					if($sql->num_rows() >0)
					{return $sql->result_array();
					}else
					{return false;}
					}

					

					public function tansform_check($id){
						$this->db->select('*');  
						  
						$this->db->from('release_batch');
						
						$this->db->where('so_id',$id);
						
						$sql = $this->db->get();
				
						if($sql->num_rows() >0)
						{return $sql->result_array();
						}else
						{return false;}
						}

		public function get_products_packing(){
		$this->db->select('materials.id,materials.name');  
		  
		$this->db->from('materials');
		
		$this->db->where('type',2);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

public function get_plan_data()
		{
		$this->db->select('production_plan.so_id');
		$this->db->from('production_plan');
			$this->db->group_by('production_plan.so_id');
		$sql = $this->db->get();
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}



		public function get_so_production_products($so_id)
		{
		$this->db->select('production_plan.so_id,production_plan.job,production_plan.product_name,production_plan.party_id,production_plan.pro_qty,production_plan.material_id,production_plan.bom_qty,production_plan.bom_unit,production_plan.in_stock_qty,production_plan.p_qty,production_plan.color_id,production_plan.cutting_ratio,production_plan.spec_no,production_plan.mold,production_plan.remarks,production_plan.created,production_machine_remarks.machine,production_machine_remarks.expected');
		$this->db->from('production_plan');
		
		$this->db->join('production_machine_remarks','production_plan.so_id = production_machine_remarks.so_id','left');
			$this->db->where('production_plan.so_id',$so_id);
			
		$sql = $this->db->get();
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}


		

		public function get_so_production_production_id($machine)
		{
		$this->db->select('production_machine_remarks.so_id,production_machine_remarks.product_id,production_machine_remarks.machine,production_machine_remarks.expected');
		$this->db->from('production_machine_remarks');
		
		  //$this->db->join('production_machine_remarks','production_plan.so_id = production_machine_remarks.so_id','left');
			$this->db->where('production_machine_remarks.machine',$machine);

			$this->db->where('production_machine_remarks.status',0);
			
		$sql = $this->db->get();
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}


		

		public function get_so_production_production_data($so_id,$p_name)
		{
		$this->db->select('production_plan.so_id,production_plan.product_name,production_plan.p_qty,production_plan.job');
		$this->db->from('production_plan');
		
		  //$this->db->join('production_plan','production_plan.so_id = production_plan.so_id','left');
			$this->db->where('production_plan.so_id',$so_id);
			$this->db->where('production_plan.product_name',$p_name);
			$this->db->where('production_plan.complete_status',0);
			
		$sql = $this->db->get();
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

		

		public function get_products_raw_material(){
		$this->db->select('materials.id,materials.name,materials.grade');  
		  
		$this->db->from('materials');
		
		$this->db->where('type',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		


		public function get_complete_semi_productions($product_ids){
		$this->db->select('sum(in_stock_log.qty) as total');  
		  
		$this->db->from('in_stock_log');
		
		//this->db->where('so_id',$so_id);

		$this->db->where('product_id',$product_ids);
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function get_products_semi_type(){
		$this->db->select('product_type.id,product_type.name');  
		  
		$this->db->from('product_type');
		$this->db->where('id !=',1);
	
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_products_machine(){
		$this->db->select('machines.id,machines.machine_name');  
		  
		$this->db->from('machines');
		
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		public function get_color(){
		$this->db->select('production_color.id,production_color.name');  
		  
		$this->db->from('production_color');
		
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		

		public function get_products_raw_material_wast_productionout(){
		$this->db->select('stock_out_production.material_id');  
		  
		$this->db->from('stock_out_production');
		
		//$this->db->where('id',$product_id);
		$this->db->group_by('stock_out_production.material_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_product_details($product_id){
		$this->db->select('products.pro_code,products.product_type');  
		  
		$this->db->from('products');
		
		$this->db->where('id',$product_id);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		
		
		public function get_total($product_id,$so_id){
		$this->db->select('sum(in_stock_log.qty) as total_qty');  
		  
		$this->db->from('in_stock_log');
		
		$this->db->where('product_id',$product_id);
		$this->db->where('so_id',$so_id);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_total11($product_id){
		$this->db->select('sum(in_stock_log.qty) as total_qty');  
		  
		$this->db->from('in_stock_log');
		
		$this->db->where('product_id',$product_id);
		//$this->db->where('so_id',$so_id);
		$sql = $this->db->get();
    
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_material_id_details($material_id){
		$this->db->select('materials.material_code,materials.type');  
		  
		$this->db->from('materials');
		
		$this->db->where('id',$material_id);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_color_id_details($color_id){
		$this->db->select('production_color.code,production_color.name');  
		  
		$this->db->from('production_color');
		
		$this->db->where('id',$color_id);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_total_material($material_id){
		$this->db->select('sum(in_stock_log.qty) as total_qty');  
		  
		$this->db->from('in_stock_log');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function production_stock($material_id){
		$this->db->select('production_stock.qty as total_qty');  
		  
		$this->db->from('production_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}



		public function get_total_color_stock($material_id){
		$this->db->select('fg_stock.qty as total_qty_color');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}
		
		
		public function get_total_out_packing($material_id){
	    $this->db->select('SUM(stock_out.qty)  as total_qty_out');    
		  
		$this->db->from('stock_out');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		

		public function get_total_material_wast($material_id){
		$this->db->select('waste_in_stock.qty as total_qty');  
		  
		$this->db->from('waste_in_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		

		/*public function get_total_color($color_id){
		$this->db->select('fg_stock.qty as total_qty');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('color_id',$color_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}*/

		public function get_total_color($color_id){
		$this->db->select('sum(in_stock_log.qty) as total_qty');  
		  
		$this->db->from('in_stock_log');
		
		$this->db->where('color_id',$color_id);
		//$this->db->where('inout',1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		

			public function get_total_out_material($material_id){
			$this->db->select('SUM(stock_out_production.qty) as total_qty_out');  
			 
			$this->db->from('stock_out_production');

			$this->db->where('material_id',$material_id);
			//$this->db->where('inout',0);
			$sql = $this->db->get();
			
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}


			public function production_stock_return($material_id){
			$this->db->select('SUM(production_stock_return.qty) as total_qty_out');  
			 
			$this->db->from('production_stock_return');

			$this->db->where('material_id',$material_id);
			//$this->db->where('inout',0);
			$sql = $this->db->get();
			
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}


			public function production_compund_stock_out($material_id){
			$this->db->select('SUM(production_compund_stock_out.qty) as pro_comp_stockout');  
			 
			$this->db->from('production_compund_stock_out');

			$this->db->where('material_id',$material_id);
			//$this->db->where('inout',0);
			$sql = $this->db->get();
			
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			
			public function get_total_material_last_balance($material_id,$machine_id,$product_id){
			$this->db->select('production_stock.balance as last_blance');  
			 
			$this->db->from('production_stock');

			$this->db->where('material_id',$material_id);
			$this->db->where('machine_id',$machine_id);
			$this->db->where('product_id',$product_id);
			//$this->db->where('inout',0);
			$sql = $this->db->get();
			
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}


			
			public function get_unit(){
			$this->db->select('units.id,units.names');  
			 
			$this->db->from('units');

		
			//$this->db->where('inout',0);
			$sql = $this->db->get();
			
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			public function get_total_out_material_wast($material_id){
			$this->db->select('SUM(waste_out_stock.qty) as total_qty_out');  
			 
			$this->db->from('waste_out_stock');

			$this->db->where('material_id',$material_id);
			//$this->db->where('inout',0);
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}



		public function get_total_out_color($color_id){
		$this->db->select('SUM(stock_out.qty) as total_qty_out');  
		  
		$this->db->from('stock_out');
		
		$this->db->where('color_id',$color_id);
		//$this->db->where('inout',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		public function get_material_code_production($material_id){
		$this->db->select('SUM(stock_out_production.qty) as total_qty_out');  
		  
		$this->db->from('stock_out_production');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_material_stock_production($material_id){
		$this->db->select('SUM(production_compund_stock_out.qty) as total_qty_out');  
		  
		$this->db->from('production_compund_stock_out');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_material_code_production_wast($material_id){
		$this->db->select('SUM(stock_out_production.weight_wast) as total_qty_out');  
		  
		$this->db->from('stock_out_production');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('inout',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_total_out($product_id){
		$this->db->select('SUM(stock_out.qty) as total_qty_out');  
		  
		$this->db->from('stock_out');
		
		$this->db->where('product_id',$product_id);
		//$this->db->where('inout',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		

		public function release_batch_assembled($save_data) {
			$result = $this->db->insert('assembled_line_assign',$save_data);
			if($result){return true;}else{return false;} 
			
	  }
	  

	 
	  
	  public function insert_assembled_transform_batch($save_data) {
		$result = $this->db->insert('release_batch_lineclerence',$save_data);
		if($result){return true;}else{return false;} 
		
  }


		public function add_fg($save_data) {
          $result = $this->db->insert('fg_stock',$save_data);
          if($result){return true;}else{return false;} 
		  
    }

	
	
	public function add_logs_tranform($save_data) {
		$result = $this->db->insert('transform_logs',$save_data);
		if($result){return true;}else{return false;} 
		
  }

	public function add_new_batch($save_data) {
		$result = $this->db->insert('release_batch',$save_data);
		if($result){return $this->db->insert_id();}else{return false;} 
		
  }

  
  public function batch_assign_to_batch_size($save_data) {
	$result = $this->db->insert('batch_assign_to_batch_size',$save_data);
	if($result){return true;}else{return false;} 
	
}

  public function add_new_batch_machine($save_data) {
		$result = $this->db->insert('prinnting_line_machine',$save_data);
		if($result){return true;}else{return false;} 
		
  }

  public function add_new_batch_sealingmachine($save_data) {
	$result = $this->db->insert('sealing_line_machine',$save_data);
	if($result){return true;}else{return false;} 
	
}

  public function add_new_batch_line($save_data) {
	$result = $this->db->insert('assembled_line_assign',$save_data);
	if($result){return true;}else{return false;} 
	
}

    public function add_fg_log($save_log) {
          $result = $this->db->insert('in_stock_log',$save_log);
          if($result){return $this->db->insert_id();}else{return false;} 
		  
    }


	public function log_production_mat($save_log) {
          $result = $this->db->insert('production_stock_log',$save_log);
          if($result){return true;}else{return false;} 
		  
    }

	
	public function add_line_clerence_print($save_log) {
		$result = $this->db->insert('printing_line_clerence',$save_log);
		if($result){return true;}else{return false;} 
		
  }
  

  public function add_line_clerence_sealed($save_log) {
	$result = $this->db->insert('sealing_line_clerence',$save_log);
	if($result){return true;}else{return false;} 
	
}
  
  public function add_line_clerence_assembled($save_log) {
	$result = $this->db->insert('assembled_line_clerence',$save_log);
	if($result){return true;}else{return false;} 
	
}
  
  public function add_line_clerence_area($save_log) {
	$result = $this->db->insert('assembled_line',$save_log);
	if($result){return true;}else{return false;} 
	
}

/*public function add_printed_stock($printing_line) {
          $result = $this->db->insert('printing_line',$printing_line);
          if($result){return true;}else{return false;} 
		  
    }
*/
    public function add_production_mat($dataarray) {
          $result = $this->db->insert('production_stock',$dataarray);
          if($result){return true;}else{return false;} 
		  
    }

    public function add_production_mat_out($dataarray) {
          $result = $this->db->insert('production_stock_return',$dataarray);
          if($result){return true;}else{return false;} 
		  
    }


    public function add_wast($save_data) {
          $result = $this->db->insert('waste_in_stock',$save_data);
          if($result){return true;}else{return false;} 
		  
    }

    public function add_wast_log($save_log) {
          $result = $this->db->insert('waste_in_stock_log',$save_log);
          if($result){return $this->db->insert_id();}else{return false;} 
		  
    }
    
    
    public function get_waste_data($id){

     $this->db->select('waste_in_stock_log.qty,waste_in_stock_log.created,waste_in_stock_log.material_id,waste_in_stock_log.wast_lot');  
 
		$this->db->from('waste_in_stock_log');
		$this->db->where('waste_in_stock_log.id',$id);

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

public function get_products_semi_reports(){

     $this->db->select('fg_stock.qty,fg_stock.created,fg_stock.product_id');  
 
		$this->db->from('fg_stock');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'left');
		//$this->db->join('in_stock_log', 'fg_stock.product_id = in_stock_log.product_id', 'left');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'right');
		$this->db->where('fg_stock.type !=',5);
		$this->db->where('fg_stock.product_id !=','');
		//$this->db->group_by('fg_stock.product_id');

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

		    }



public function get_products_packing_reports(){

     $this->db->select('fg_stock.qty,fg_stock.created,fg_stock.material_id');  
 
		$this->db->from('fg_stock');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'left');
		//$this->db->join('in_stock_log', 'fg_stock.product_id = in_stock_log.product_id', 'left');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'right');
		$this->db->where('fg_stock.type !=',1);
		$this->db->where('fg_stock.material_id !=','');
		//$this->db->group_by('fg_stock.product_id');

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }


		    
 public function get_products_raw_reports(){

     $this->db->select('fg_stock.qty,fg_stock.created,fg_stock.material_id');  
 
		$this->db->from('fg_stock');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'left');
		//$this->db->join('in_stock_log', 'fg_stock.product_id = in_stock_log.product_id', 'left');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'right');
		
		$this->db->where('fg_stock.type !=',2);

		$this->db->where('fg_stock.material_id !=','');
		//$this->db->group_by('fg_stock.product_id');

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

	 
	  public function get_products_color_reports(){

     $this->db->select('fg_stock.qty,fg_stock.created,fg_stock.color_id');  
 
		$this->db->from('fg_stock');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'left');
		//$this->db->join('in_stock_log', 'fg_stock.product_id = in_stock_log.product_id', 'left');
		//$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'right');
		
		//$this->db->where('fg_stock.type !=',2);

		$this->db->where('fg_stock.color_id !=','');
		//$this->db->group_by('fg_stock.product_id');

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }
	 

	 public function get_assembled_line(){

        $this->db->select('*');  
 
		$this->db->from('release_batch');
		$this->db->where('depart',3);
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }
	 

	 public function assembled_line_assign(){

        $this->db->select('*');  
 
		$this->db->from('assembled_line_assign');
		$this->db->where('status !=',3);
		$this->db->group_by('batch_no');
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }
	 

	 public function lines(){

        $this->db->select('*');  
 
		$this->db->from('assembled_line');
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

	  public function get_sealing_line(){

     $this->db->select('*');  
 
		$this->db->from('release_batch');
		
		$this->db->where('depart',4);
		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

	 
	 public function packing_fg_line(){

     $this->db->select('*');  
 
		$this->db->from('in_stock_log');
		
		$this->db->where('in_stock_log.moving_to',1);
		//$this->db->group_by('fg_line.batch');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }


	 

	  public function printing_line(){

     $this->db->select('*');  
 
		$this->db->from('release_batch');
		
		$this->db->where('depart',2);

		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

	 
	 public function other_machine(){

		$this->db->select('*');  
	
		   $this->db->from('other_machine');
		   $this->db->where('type',1);
		   $sql = $this->db->get();
   
		   if($sql->num_rows() >0)
		   { return $sql->result_array();
   
		   }else
		   {return false;}
   
		}

		

		public function other_machine_sealing(){

			$this->db->select('*');  
		
			   $this->db->from('other_machine');
			   $this->db->where('type',2);
			   $sql = $this->db->get();
	   
			   if($sql->num_rows() >0)
			   { return $sql->result_array();
	   
			   }else
			   {return false;}
	   
			}

		
		public function update_printing_machine($id){

			$this->db->select('*');  
		
			   $this->db->from('prinnting_line_machine');
			   $this->db->where('id',$id);
			   $sql = $this->db->get();
	   
			   if($sql->num_rows() >0)
			   { return $sql->result_array();
	   
			   }else
			   {return false;}
	   
			}


			public function update_sealing_machine($id){

				$this->db->select('*');  
			
				   $this->db->from('sealing_line_machine');
				   $this->db->where('id',$id);
				   $sql = $this->db->get();
		   
				   if($sql->num_rows() >0)
				   { return $sql->result_array();
		   
				   }else
				   {return false;}
		   
				}

	 public function printing_line_machine(){

		$this->db->select('*');  
	
		   $this->db->from('prinnting_line_machine');
		   $this->db->where('status !=',3);
		   $sql = $this->db->get();
   
		   if($sql->num_rows() >0)
		   { return $sql->result_array();
   
		   }else
		   {return false;}
   
		}


		public function sealing_line_machine(){

			$this->db->select('*');  
		
			   $this->db->from('sealing_line_machine');
			   //$this->db->where('id',1);
			   $sql = $this->db->get();
	   
			   if($sql->num_rows() >0)
			   { return $sql->result_array();
	   
			   }else
			   {return false;}
	   
			}
		

		public function sealed_line_machine(){

			$this->db->select('*');  
		
			   $this->db->from('sealing_line_machine');
			   $this->db->where('status !=',3);
			   $sql = $this->db->get();
	   
			   if($sql->num_rows() >0)
			   { return $sql->result_array();
	   
			   }else
			   {return false;}
	   
			}


	 public function match_batch($batch){

     $this->db->select('fg_line.batch');  
 
		$this->db->from('assembled_line');
		$this->db->join('fg_line', 'assembled_line.batch = fg_line.batch', 'left');
		$this->db->join('sealed_line', 'sealed_line.batch = assembled_line.batch', 'left');
		$this->db->join('printed_line', 'printed_line.batch = sealed_line.batch', 'left');
		
		//$this->db->where('fg_stock.type !=',2);

		$this->db->where('fg_line.batch',$batch);
		$this->db->where('fg_line.status !=',0);

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }


	 public function get_products_wast(){

     $this->db->select('waste_in_stock.qty,waste_in_stock.created,waste_in_stock.material_id,waste_in_stock.wast_lot');  
 
		$this->db->from('waste_in_stock');
		//$this->db->join('stock_out', 'waste_in_stock.product_id = stock_out.product_id', 'left');
		//$this->db->join('in_stock_log', 'waste_in_stock.product_id = in_stock_log.product_id', 'left');
		//$this->db->join('stock_out', 'waste_in_stock.product_id = stock_out.product_id', 'right');
		
		//$this->db->where('waste_in_stock.type !=',2);

		//$this->db->where('waste_in_stock.color_id !=','');
		//$this->db->group_by('fg_stock.product_id');

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

	 
	 public function get_products_production_reports(){
	 	  $date = date('Y-m-d');
 
     $this->db->select('stock_out_production.created,stock_out_production.machine_id,stock_out_production.qcr,stock_out_production.wlot,stock_out_production.weight_wast,stock_out_production.qty as compund_qty,stock_out_production.created,stock_out_production.material_id,stock_out_production.color_code,stock_out_production.color_ratio');  
 
		$this->db->from('stock_out_production');
		//$this->db->join('waste_out_stock', 'stock_out_production.machine_id = waste_out_stock.machine_id', 'left');
		//$this->db->join('in_stock_log', 'stock_out_production.product_id = in_stock_log.product_id', 'left');
		//$this->db->join('stock_out', 'stock_out_production.product_id = stock_out.product_id', 'right');
		
		//$this->db->where('stock_out_production.type !=',2);

		$this->db->where('stock_out_production.insert_date',$date);
		

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }

  


     public function get_products_fg_reports(){

    	 $this->db->select('fg_stock.qty,fg_stock.created,fg_stock.product_id,stock_out.product_id as out_product,stock_out.qty as stock_out,stock_out.created as out_created,in_stock_log.qty as qty_log_stock,in_stock_log.created as log_stock_created,products.name as product_name ');  
		  
		$this->db->from('fg_stock');
		$this->db->join('stock_out', 'fg_stock.product_id = stock_out.product_id', 'left');
		$this->db->join('in_stock_log', 'fg_stock.product_id = in_stock_log.product_id', 'inner');
		$this->db->join('products', 'in_stock_log.product_id = products.id', 'inner');
		$this->db->where('fg_stock.type',5);
		$this->db->group_by('in_stock_log.product_id');
		//$this->db->limit(6);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

    }


     public function get_material_production_reports(){

    	 $this->db->select('production_stock_log.product_id,production_stock_log.material_id,production_stock_log.production_id,production_stock_log.insert_date,production_stock_log.qty,production_stock_log.unit');  
		  
		$this->db->from('production_stock_log');
	
		$this->db->order_by('production_stock_log.id','ASC');
		//$this->db->limit(6);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

    }

    


     public function get_lastqty_production_stock($material_id,$machine_id,$product_id){

     $this->db->select('production_stock.balance');  
 
		$this->db->from('production_stock');
		
		$this->db->where('production_stock.material_id',$material_id);
		$this->db->where('production_stock.machine_id',$machine_id);
		$this->db->where('production_stock.product_id',$product_id);
		//$this->db->order_by('production_stock.product_id');

		$sql = $this->db->get();


		if($sql->num_rows() >0)
		{ return $sql->result_array();

		}else
		{return false;}

	 }



    public function get_product_for_condition($product_id){

    	$this->db->select('fg_stock.product_id,fg_stock.qty,fg_stock.created');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('product_id',$product_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }

	

	public function sales_order_open_order(){

    	$this->db->select('sales_order.id,sales_order.so_no,sales_order.party_id,sales_order.status,sales_order_products.product_id,sales_order_products.quantity');  
		  
		$this->db->from('sales_order');
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'left');
		$this->db->where('status',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }


	public function sales_order_open_order_id($id){

    	$this->db->select('sales_order.id,sales_order.so_no,sales_order.party_id,sales_order.status,sales_order_products.product_id,sales_order_products.quantity');  
		  
		$this->db->from('sales_order');
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'left');
		$this->db->where('status',0);
		$this->db->where('sales_order.id',$id);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }


    

     public function get_material_wast_for_condition($material_id){

    	$this->db->select('waste_in_stock.material_id,waste_in_stock.qty,waste_in_stock.created');  
		  
		$this->db->from('waste_in_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }


     public function get_material_production_for_condition($material_id){

    	$this->db->select('production_stock.material_id,production_stock.qty,production_stock.created');  
		  
		$this->db->from('production_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }
    
    
     public function get_material_for_condition_waste($material_id){

    	$this->db->select('waste_in_stock.material_id,waste_in_stock.qty,waste_in_stock.created');  
		  
		$this->db->from('waste_in_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }


    

    public function get_material_for_condition($material_id){

    	$this->db->select('fg_stock.material_id,fg_stock.qty,fg_stock.created');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }

    

    public function getproduction_stock($material_id,$machine_id,$product_id){

    	$this->db->select('production_stock.material_id,production_stock.balance');  
		  
		$this->db->from('production_stock');
		
		$this->db->where('material_id',$material_id);
		$this->db->where('machine_id',$machine_id);
		$this->db->where('product_id',$product_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }



    public function get_color_for_condition($color_id){

    	$this->db->select('fg_stock.color_id,fg_stock.qty,fg_stock.created');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('color_id',$color_id);
		//$this->db->group_by('product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
    }

    
    public function update_stock($id,$dataarray) {
		$result = $this->db->where('product_id',$id);
		$result = $this->db->update('fg_stock',$dataarray);
		if($result){return true;}else{return false;}
	}

	
	public function update_status($id,$dataarray) {
		$result = $this->db->where('so_id',$id);
		$result = $this->db->update('release_batch',$dataarray);
		if($result){return true;}else{return false;}
	}

	
	public function update_transform_product_batch($batch_id,$dataarray) {
		$result = $this->db->where('id',$batch_id);
		$result = $this->db->update('release_batch',$dataarray);
		if($result){return true;}else{return false;}
	}

	public function update_transform_product_release($batch_no,$dataarray) {
		$result = $this->db->where('batch',$batch_no);
		$result = $this->db->update('release_batch',$dataarray);
		if($result){return true;}else{return false;}
	}
	

	public function update_transform_batch($batch_id,$dataarray) {
		$result = $this->db->where('id',$batch_id);
		$result = $this->db->update('release_batch',$dataarray);
		if($result){return true;}else{return false;}
	}

	
	public function update_transform_machine($batch_id) {
		$result = $this->db->where('batch',$batch_id);
		$result = $this->db->update('prinnting_line_machine',array('status'=>3));
		if($result){return true;}else{return false;}
	}


	public function update_transform_machine_sealing($batch_id) {
		$result = $this->db->where('batch',$batch_id);
		$result = $this->db->update('sealing_line_machine',array('status'=>3));
		if($result){return true;}else{return false;}
	}


	public function update_transform_machine_assembled($batch_id) {
		$result = $this->db->where('batch',$batch_id);
		$result = $this->db->update('assembled_line_assign',array('status'=>3));
		if($result){return true;}else{return false;}
	}

	
	public function update_assign_machine($id,$dataarray1) {
		$result = $this->db->where('id',$id);
		$result = $this->db->update('prinnting_line_machine',$dataarray1);
		if($result){return true;}else{return false;}
	}

	
	
	public function update_assign_machine_sealing($id,$dataarray1) {
		$result = $this->db->where('id',$id);
		$result = $this->db->update('sealing_line_machine',$dataarray1);
		if($result){return true;}else{return false;}
	}

	public function update_assign_assembled_status($batch,$dataarray1) {
		$result = $this->db->where('batch_no',$batch);
		//$result = $this->db->where('product',$pro);
		$result = $this->db->update('assembled_line_assign',$dataarray1);
		if($result){return true;}else{return false;}
	}
	

	public function update_stock_instock_logs($id,$dataarray) {
		$result = $this->db->where('id',$id);
		$result = $this->db->update('in_stock_log',$dataarray);
		if($result){return true;}else{return false;}
	}

	public function update_assign_machine_printing_status($id,$dataarray) {
		$result = $this->db->where('id',$id);
		$result = $this->db->update('prinnting_line_machine',$dataarray);
		if($result){return true;}else{return false;}
	}


	public function update_assign_machine_sealed_status($id,$dataarray) {
		$result = $this->db->where('id',$id);
		$result = $this->db->update('sealing_line_machine',$dataarray);
		if($result){return true;}else{return false;}
	}

public function update_stock_status($product_id,$so_id) {
		$result = $this->db->where('product_id',$product_id);
		$result = $this->db->where('so_id',$so_id);
		$result = $this->db->update('in_stock_log',array('pcs_status' =>0));
		if($result){return true;}else{return false;}
	}
	
	public function update_release_batch_lineclerence($printed_id) {
		$result = $this->db->where('id',$printed_id);
		$result = $this->db->update('release_batch',array('status' =>2));
		if($result){return true;}else{return false;}
	}

	public function update_machine_status($product_id,$so_id) {
		
		$result = $this->db->where('so_id',$so_id);
		$result = $this->db->where('product_id',$product_id);
		$result = $this->db->where('status',0);
		$result = $this->db->update('production_machine_remarks',array('status' =>1));
		if($result){return true;}else{return false;}
	}


	public function update_production_plan_status($p_name,$so_id) {
		$result = $this->db->where('so_id',$so_id);
		$result = $this->db->where('product_name',$p_name);
		$result = $this->db->where('complete_status',0);
		$result = $this->db->update('production_plan',array('complete_status' =>1));
		if($result){return true;}else{return false;}
	}

		public function update_production_plan_complete($production_id) {
		$result = $this->db->where('id',$production_id);
		
		$result = $this->db->update('production_plan',array('status' =>10));
		if($result){return true;}else{return false;}
	}


	 public function update_stock_wast($id,$dataarray) {
		$result = $this->db->where('material_id',$id);
		$result = $this->db->update('waste_in_stock',$dataarray);
		if($result){return true;}else{return false;}
	}


	public function update_stock_return($id,$dataarray) {
		$result = $this->db->where('material_id',$id);
		$result = $this->db->update('production_stock',$dataarray);
		if($result){return true;}else{return false;}
	}


	public function update_stock_material($id,$dataarray) {
		$result = $this->db->where('material_id',$id);
		$result = $this->db->update('fg_stock',$dataarray);
		if($result){return true;}else{return false;}
	}


	public function update_stock_color($color_id,$dataarray) {
		$result = $this->db->where('color_id',$color_id);
		$result = $this->db->update('fg_stock',$dataarray);
		if($result){return true;}else{return false;}
	}
	
	public function add_out_waste_Stock($dataarray) {
          $result = $this->db->insert('waste_out_stock',$dataarray);
          if($result){return true;}else{return false;} 
		  
    }


    	public function add_assembled_stock($assembled_line) {
          $result = $this->db->insert('assembled_line',$assembled_line);
          if($result){return true;}else{return false;} 
		  
    }

    

    public function add_sealed_stock($sealed_line) {
          $result = $this->db->insert('sealed_line',$sealed_line);
          if($result){return true;}else{return false;} 
		  
    }
    
    public function add_fg_stock($fg_line) {
          $result = $this->db->insert('fg_line',$fg_line);
          if($result){return true;}else{return false;} 
		  
    }

    

     public function add_printed_stock($printed_line) {
          $result = $this->db->insert('printed_line',$printed_line);
          if($result){return true;}else{return false;} 
		  
    }

    
    public function add_qty_production_log($updateqty_log) {
          $result = $this->db->insert('production_stock_log',$updateqty_log);
          if($result){return true;}else{return false;} 
		  
    }

	public function add_out_stock($dataarray) {
          $result = $this->db->insert('stock_out',$dataarray);
          if($result){return true;}else{return false;} 
		  
    }


	public function update_qty_production($updateqty,$material_id,$machine_id,$product_id) {
		$result = $this->db->where('material_id',$material_id);
		$result = $this->db->where('machine_id',$machine_id);
		$result = $this->db->where('product_id',$product_id);
		$result = $this->db->update('production_stock',$updateqty);
		if($result){return true;}else{return false;}
	}

		
		/*public function add_qty_production_log($updateqty_log,$material_id,$machine_id,$product_id) {
		$result = $this->db->where('material_id',$material_id);
		$result = $this->db->where('machine_id',$machine_id);
		$result = $this->db->where('product_id',$product_id);
		$result = $this->db->update('production_stock_log',$updateqty_log);
		if($result){return true;}else{return false;}
	}*/
    

    public function update_production_mat($material_id,$machine_id,$product_id,$dataarray1) {
		$result = $this->db->where('material_id',$material_id);
		$result = $this->db->where('machine_id',$machine_id);
		$result = $this->db->where('product_id',$product_id);
		$result = $this->db->update('production_stock',$dataarray1);
		if($result){return true;}else{return false;}
	}

    public function add_out_stock_production($dataarray) {
          $result = $this->db->insert('stock_out_production',$dataarray);
          if($result){return true;}else{return false;} 
		  
    }


    public function update_stock_out($id) {
		$result = $this->db->where('product_id',$id);
		$result = $this->db->update('stock_out',$_POST);
		if($result){return true;}else{return false;}
	}


	public function update_waste_status($machine_id) {
		$result = $this->db->where('machine_id',$machine_id);
		
		$result = $this->db->update('waste_out_stock',array('status' =>1));
		if($result){return true;}else{return false;}
	}


	public function get_total_machine_wast($machine_id){
		$this->db->select('waste_out_stock.qty as total_qty,waste_out_stock.wast_lot');  
		  
		$this->db->from('waste_out_stock');
		
		$this->db->where('machine_id',$machine_id);
		$this->db->where('status',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}
		
		public function get_total_production_wast($material_id){
		$this->db->select('SUM(waste_out_stock.qty) as total_qty,waste_out_stock.wast_lot');  
		  
		$this->db->from('waste_out_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('status',0);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function production_plan_complete_status($so_id){
		$this->db->select('production_plan.complete_status');  
		  
		$this->db->from('production_plan');
		
		//$this->db->where('product_name',$p_name);
		$this->db->where('so_id',$so_id);

		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_recods_update($in_out){
		$this->db->select('in_stock_log.id,in_stock_log.qty,in_stock_log.product_id,in_stock_log.type,in_stock_log.insert_date');  
		  
		$this->db->from('in_stock_log');
		
		$this->db->where('type',$in_out);
		$this->db->where('product_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		

		public function get_recods_packing_in(){
		$this->db->select('in_stock_log.id,in_stock_log.qty,in_stock_log.material_id,in_stock_log.type,in_stock_log.insert_date');  
		  
		$this->db->from('in_stock_log');
		
		
		$this->db->where('material_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function get_recods_color_in(){
		$this->db->select('in_stock_log.id,in_stock_log.qty,in_stock_log.color_id,in_stock_log.type,in_stock_log.insert_date');  
		  
		$this->db->from('in_stock_log');
		
		
		$this->db->where('color_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		public function get_recods_waste_in(){
		$this->db->select('waste_in_stock_log.id,waste_in_stock_log.qty,waste_in_stock_log.material_id,waste_in_stock_log.insert_date');  
		  
		$this->db->from('waste_in_stock_log');
		
		
		$this->db->where('material_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}
			
		public function get_recods_color_out(){
		$this->db->select('stock_out.id,stock_out.qty,stock_out.color_id,stock_out.type,stock_out.insert_date');  
		  
		$this->db->from('stock_out');
		
		
		$this->db->where('color_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}




		public function get_recods_update_out(){
		$this->db->select('stock_out.id,stock_out.qty,stock_out.product_id,stock_out.type,stock_out.insert_date');  
		  
		$this->db->from('stock_out');
		
		
		$this->db->where('product_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}
		

		public function get_recods_packing_out(){
		$this->db->select('stock_out.id,stock_out.qty,stock_out.material_id,stock_out.type,stock_out.insert_date');  
		  
		$this->db->from('stock_out');
		
		
		$this->db->where('material_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_recods_waste_out(){
		$this->db->select('waste_out_stock.id,waste_out_stock.qty,waste_out_stock.material_id,waste_out_stock.insert_date');  
		  
		$this->db->from('waste_out_stock');
		
		
		$this->db->where('material_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function get_recods_production(){
		$this->db->select('stock_out_production.id,stock_out_production.qty,stock_out_production.material_id,stock_out_production.insert_date,stock_out_production.machine_id');  
		  
		$this->db->from('stock_out_production');
		
		
		$this->db->where('material_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}




		

		public function getfgstock_record_semi($pro){
		$this->db->select('fg_stock.qty');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('product_id',$pro);
		//$this->db->where('product_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function getfgstock_record_packing($mat){
		$this->db->select('fg_stock.qty');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('material_id',$mat);
		//$this->db->where('product_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function getfgstock_record_color($color){
		$this->db->select('fg_stock.qty');  
		  
		$this->db->from('fg_stock');
		
		$this->db->where('color_id',$color);
		//$this->db->where('product_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function batch_qty_total($batch_id){
			$this->db->select('SUM(release_batch.transform_qty) AS transform_qty');  
			  
			$this->db->from('release_batch');
			
			$this->db->where('id',$batch_id);
			//$this->db->where('product_id !=',"");
			
			$sql = $this->db->get();
	
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			

			public function packing_batch(){
				$this->db->select('SUM(qty) as qty,id,batch,transform,type');  
				  
				$this->db->from('transform_logs');
				$this->db->where('type',5);
				$this->db->where('status',0);
				$sql = $this->db->get();
		
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}


		public function getfgstock_record_waste($material_id){
		$this->db->select('waste_in_stock.qty,waste_in_stock.wast_lot');  
		  
		$this->db->from('waste_in_stock');
		
		$this->db->where('material_id',$material_id);
		//$this->db->where('product_id !=',"");
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		

		  public function get_product_details_productions($machine_id){
			$this->db->select('production_plan.product_name,production_plan.job,production_plan.material_id');  
			  
			$this->db->from('production_plan');
			
			$this->db->where('id',$machine_id);
			//$this->db->where('product_id !=',"");
			
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			

			public function get_products_raw_material_production(){

			$this->db->select('production_machine_remarks.machine');  
			  
			$this->db->from('production_machine_remarks');
			
			$this->db->where('status',0);
			//$this->db->where('product_id !=',"");
			
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

		public function update_fgstock_semi($pro,$dataarray) {
		$result = $this->db->where('product_id',$pro);
		$result = $this->db->update('fg_stock',$dataarray);
		if($result){return true;}else{return false;}
	}


	public function update_fgstock_packing($mat,$dataarray) {
		$result = $this->db->where('material_id',$mat);
		$result = $this->db->update('fg_stock',$dataarray);
		if($result){return true;}else{return false;}
	}

public function update_fgstock_color($color,$dataarray) {
		$result = $this->db->where('color_id',$color);
		$result = $this->db->update('fg_stock',$dataarray);
		if($result){return true;}else{return false;}
	}


	public function update_fgstock_waste($waste,$dataarray) {
		$result = $this->db->where('material_id',$waste);
		$result = $this->db->update('waste_in_stock',$dataarray);
		if($result){return true;}else{return false;}
	}

	public function delete_record_semi($id)
	{
		$sql = $this->db->delete('in_stock_log', array('id'=>$id));
		
		return true;
	}

	
	public function delete_record_packing($id)
	{
		$sql = $this->db->delete('in_stock_log', array('id'=>$id));
		
		return true;
	}


	public function delete_record_color($id)
	{
		$sql = $this->db->delete('in_stock_log', array('id'=>$id));
		
		return true;
	}

	public function delete_record_semi_out($id)
	{
		$sql = $this->db->delete('stock_out', array('id'=>$id));
		
		return true;
	}
	

	public function delete_recods_packing_out($id)
	{
		$sql = $this->db->delete('stock_out', array('id'=>$id));
		
		return true;
	}
	
	public function delete_recods_color_out($id)
	{
		$sql = $this->db->delete('stock_out', array('id'=>$id));
		
		return true;
	}


	public function delete_record_waste($id)
	{
		$sql = $this->db->delete('waste_in_stock_log', array('id'=>$id));
		
		return true;
	}


	
	public function delete_record_waste_out($id)
	{
		$sql = $this->db->delete('waste_out_stock', array('id'=>$id));
		
		return true;
	}

	

	public function delete_record_production($id)
	{
		$sql = $this->db->delete('stock_out_production', array('id'=>$id));
		
		return true;
	}


	

	public function reporting_data($start,$end){
		$this->db->select('in_stock_log.created as created_in,in_stock_log.product_id,in_stock_log.type,in_stock_log.qty as in_qty,in_stock_log.insert_date as in_date,in_stock_log.user_id');  
		  
		$this->db->from('in_stock_log');
		
		 $this->db->where('in_stock_log.insert_date >=',$start);
		   $this->db->where('in_stock_log.insert_date <=',$end);
		   $this->db->where('in_stock_log.product_id !=','');
		   $this->db->order_by('in_stock_log.id','DESC');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		public function reporting_data_out($start,$end){
		$this->db->select('stock_out.created as created_out,stock_out.product_id,stock_out.type,stock_out.qty as out_qty,stock_out.insert_date as out_date,stock_out.user_id');  
		  
		$this->db->from('stock_out');
		
		 $this->db->where('stock_out.insert_date >=',$start);
		   $this->db->where('stock_out.insert_date <=',$end);
		   $this->db->where('stock_out.product_id !=','');
		   $this->db->order_by('stock_out.id','DESC');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		
		public function delete_fg_stock($id)
	{
		$sql = $this->db->delete('fg_stock', array('id'=>$id));
		
		return true;
	}


	

			public function get_production_job(){
			$this->db->select('production_machine_remarks.id,production_machine_remarks.so_id,production_machine_remarks.product_id,production_machine_remarks.machine');  
			  
			$this->db->from('production_machine_remarks');
			
			
		$this->db->where('status',0);
			
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}


			public function fg_product(){
			$this->db->select('products.id,products.name');  
			  
			$this->db->from('products');
			$this->db->where('product_type',5);
			
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}
		
			public function get_semi_product_semi(){
				$this->db->select('products.id,products.name');  
				  
				$this->db->from('products');
				$this->db->where('product_type',1);
				
				$sql = $this->db->get();
	
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}

		public function get_semi_product(){
			$this->db->select('products.id,products.name');  
			  
			$this->db->from('products');
			//$this->db->where('product_type',5);
			
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}


			public function get_semi_product_fg(){
				$this->db->select('products.id,products.name');  
				  
				$this->db->from('products');
				$this->db->where('product_type',5);
				
				$sql = $this->db->get();
	
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}


			
			public function get_semi_product_printing(){
				$this->db->select('products.id,products.name');  
				  
				$this->db->from('products');
				$this->db->where('product_type',2);
				
				$sql = $this->db->get();
	
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}


				

				public function assembled_transform_dep(){
					$this->db->select('products.id,products.name');  
					  
					$this->db->from('products');
					$this->db->where('product_type',3);
					
					$sql = $this->db->get();
		
					if($sql->num_rows() >0)
					{return $sql->result_array();
					}else
					{return false;}
					}


					
					public function sealed_transform_dep(){
						$this->db->select('products.id,products.name');  
						  
						$this->db->from('products');
						$this->db->where('product_type',4);
						
						$sql = $this->db->get();
			
						if($sql->num_rows() >0)
						{return $sql->result_array();
						}else
						{return false;}
						}
			

			/*public function get_data_from_production_job($p_name)
			{
			$this->db->select('production_plan.so_id,production_plan.job,production_plan.product_name,production_plan.party_id,production_plan.pro_qty,production_plan.material_id,production_plan.bom_qty,production_plan.bom_unit,production_plan.in_stock_qty,production_plan.p_qty,production_plan.color_id,production_plan.cutting_ratio,production_plan.spec_no,production_plan.mold,production_plan.remarks,production_plan.created,production_machine_remarks.machine,production_machine_remarks.expected');
			$this->db->from('production_plan');
			
			$this->db->join('production_machine_remarks','production_plan.so_id = production_machine_remarks.so_id','left');
			$this->db->where('production_plan.product_name',$p_name);
			$this->db->where('production_machine_remarks.status',0);
			//$this->db->where('production_plan.complete_status',0);
		//	$this->db->group_by('production_plan.material_id','DESC');
				
			$sql = $this->db->get();
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
			}*/

			public function get_data_from_production_job($product_id)
			{
			$this->db->select('production_machine_remarks.so_id,production_machine_remarks.machine,production_machine_remarks.product_id,production_machine_remarks.expected,production_machine_remarks.product_id');
			$this->db->from('production_machine_remarks');
			
			//$this->db->join('production_machine_remarks','production_plan.so_id = production_machine_remarks.so_id','left');
			$this->db->where('production_machine_remarks.machine',$product_id);
			$this->db->where('production_machine_remarks.status',0);
			//$this->db->where('production_plan.complete_status',0);
		//	$this->db->group_by('production_plan.material_id','DESC');
				
			$sql = $this->db->get();
			//print_r($this->db->last_query($sql));   die;
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
			}
			

		public function fg_get_ids_boms($product_fg){
			$this->db->select('boms.product_id');  
			  
			$this->db->from('boms');
			$this->db->where('main_product',$product_fg);
			$this->db->where('product_id !=',0);
			$this->db->group_by('boms.product_id');
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}


				public function semi_get_ids_boms($product_fg){
			$this->db->select('boms.product_id');  
			  
			$this->db->from('boms');
			$this->db->where('product_id',$product_fg);
			$this->db->where('product_id !=',0);
			$this->db->group_by('boms.product_id');
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			
			public function semi_type_products($semi_products){
			$this->db->select('products.product_type');  
			  
			$this->db->from('products');
			$this->db->where_in('id',$semi_products);
			$this->db->where('product_type !=',1);
			//$this->db->group_by('boms.child_product');
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

			public function semi_type($semi_products){
			$this->db->select('products.product_type');  
			  
			$this->db->from('products');
			$this->db->where('id',$semi_products);
			$this->db->where('product_type !=',1);
			//$this->db->group_by('boms.child_product');
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
			}

		

		public function get_molded_items_bom($fg_product){
		
		$this->db->select('boms.product_id');  
				  
		$this->db->from('boms');
		$this->db->where('main_product',$fg_product);
		$this->db->where('child_product',0);
		$this->db->group_by('boms.product_id');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}



		public function fg_print($id){
		$this->db->select('in_stock_log.carton_weight,in_stock_log.shift,in_stock_log.so_id,in_stock_log.emp_id,in_stock_log.m_weight,in_stock_log.qty_b,in_stock_log.created,in_stock_log.product_id,in_stock_log.batch,in_stock_log.qty,in_stock_log.insert_date,in_stock_log.qc_ref');  
		  
		$this->db->from('in_stock_log');
		
		
		$this->db->where('id',$id);
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_batch_number(){

			$this->db->select('release_batch.batch');  
			  
			$this->db->from('release_batch');
		
			$this->db->order_by('release_batch.id','DESC');
			
			$this->db->limit(1);
			$sql = $this->db->get();
	
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}
		}

