<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('check_login'))
{
    function check_login()
    {
    	$ci=& get_instance();
    	if($ci->session->userdata('id')){
    		return true;
    	}else{
    		redirect(base_url());
    	}
    }   
}


if ( ! function_exists('date_time'))
{
    function date_time()
    {
    	//date_default_timezone_set('America/Chicago');
    	date_default_timezone_set('Asia/Karachi');
		$date = date("Y-m-d");
		$time = date("h:i:sa");
		$datetime = array('date'=>$date,'time'=>$time);
    	return $datetime;
    }   
}
if ( ! function_exists('datetimeData'))
{
    function datetimeData($dt_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('datetime',array('dt_id'=>$dt_id));
    	return $query->result_array();
	}   
}

if ( ! function_exists('user_data'))
{
    function user_data($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('users',array('u_id'=>$id));
    	return $query->result_array();
    }   
}

if ( ! function_exists('get_last'))
{
    function get_last($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('product_id',$id);
         $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('get_last_all'))
{
    function get_last_all($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('product_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_out_all'))
{
    function get_out_all($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('product_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('get_out_balance'))
{
    function get_out_balance($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('product_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_in_balance'))
{
    function get_in_balance($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('product_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_last_created_date'))
{
    function get_last_created_date($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('in_stock_log.created');
       $ci->db->from('in_stock_log');
       $ci->db->where('product_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}


if ( ! function_exists('get_last_created_date_out'))
{
    function get_last_created_date_out($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('stock_out.created');
       $ci->db->from('stock_out');
       $ci->db->where('product_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}

if ( ! function_exists('get_out'))
{
    function get_out($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('sum(stock_out.qty) as totals');
       $ci->db->from('stock_out');
       $ci->db->where('product_id',$id);
       $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->totals;
    }   
}


if ( ! function_exists('get_material_type'))
{
    function get_material_type($nature)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('material_type',array('id'=>$nature));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('get_nature_name'))
{
    function get_nature_name($nature)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('business_nature',array('id'=>$nature));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('customers'))
{
    function customers($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('customers',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('pur_log_qty'))
{
    function pur_log_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_log',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}


if ( ! function_exists('pur_log_product'))
{
    function pur_log_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_log',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}


if ( ! function_exists('get_total_qty'))
{
    function get_total_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order',array('product_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}



if ( ! function_exists('get_unit_name'))
{
    function get_unit_name($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('units',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->names;
    }   
}


if ( ! function_exists('get_product_type'))
{
    function get_product_type($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('product_type',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('get_child_pro_type'))
{
    function get_child_pro_type($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_type;
    }   
}

if ( ! function_exists('po_number'))
{
    function po_number($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->po_no;
    }   
}


if ( ! function_exists('bom_fsg_pro'))
{
    function bom_fsg_pro($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}



if ( ! function_exists('salary_emp'))
{
    function salary_emp($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('empolyees',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->salary;
    }   
}


if ( ! function_exists('material_name'))
{
    function material_name($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('materials',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}



if ( ! function_exists('fullname'))
{
    function fullname($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->fullname;
    }   
}




if ( ! function_exists('depart_emp'))
{
    function depart_emp($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->depart;
    }   
}

if ( ! function_exists('main_so_po_id'))
{
    function main_so_po_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_po_id;
    }   
}


if ( ! function_exists('get_material_id'))
{
    function get_material_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}


if ( ! function_exists('color_mat'))
{
    function color_mat($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->color;
    }   
}



if ( ! function_exists('product_name'))
{
    function product_name($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	return $query->first_row()->name;
    }   
}

if ( ! function_exists('product_ref_code'))
{
    function product_ref_code($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->ref_no;
    }   
}


if ( ! function_exists('product_color'))
{
    function product_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->ref_no;
    }   
}

if ( ! function_exists('product_weight'))
{
    function product_weight($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->weight;
    }   
}

if ( ! function_exists('product_code'))
{
function product_code($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	return $query->first_row()->pro_code;
    }   
}


if ( ! function_exists('product_remark'))
{
function product_remark($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->remarks;
    }   
}


if ( ! function_exists('material_make'))
{
function material_make($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('materials',array('id'=>$id));
    	return $query->first_row()->make;
    }   
}

if ( ! function_exists('material_garde'))
{
function material_garde($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        return $query->first_row()->grade;
    }   
}


if ( ! function_exists('material_codess'))
{
    function material_codess($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_code;
    }   
}


if ( ! function_exists('depart'))
{
    function depart($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('department',array('id'=>$id));
    	return $query->first_row()->depart;
    }   
}


if ( ! function_exists('bom_product'))
{
    function bom_product($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	return $query->first_row()->name;
    }   
}


if ( ! function_exists('vendor'))
{
    function vendor($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('vendors',array('id'=>$id));
    	return $query->first_row()->vendor_name;
    }   
}

if ( ! function_exists('vendor_code'))
{
    function vendor_code($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('vendors',array('id'=>$id));
    	return $query->first_row()->code;
    }   
}



if ( ! function_exists('mat_id'))
{
    function mat_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('id'=>$id));
        return $query->first_row()->material_id;
    }   
}

if ( ! function_exists('pro_id'))
{
    function pro_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('id'=>$id));
        return $query->first_row()->product_id;
    }   
}



if ( ! function_exists('attn'))
{
    function attn($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->attn;
    }   
}


if ( ! function_exists('addres_vendor'))
{
    function addres_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->address;
    }   
}



if ( ! function_exists('email_vendor'))
{
    function email_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->email;
    }   
}

if ( ! function_exists('phone_vendor'))
{
    function phone_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->phone;
    }   
}


if ( ! function_exists('material_type_po'))
{
    function material_type_po($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->type;
    }   
}


if ( ! function_exists('dc_weight'))
{
    function dc_weight($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->weight;
    }   
}



if ( ! function_exists('partyname'))
{
    function partyname($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}



if ( ! function_exists('dc_weight_pro'))
{
    function dc_weight_pro($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->weight;
    }   
}


if ( ! function_exists('requisition_type'))
{
    function requisition_type($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->type;
    }   
}





if ( ! function_exists('type_vender_name'))
{
    function type_vender_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors_type',array('id'=>$id));
        return $query->first_row()->type;
    }   
}


if ( ! function_exists('mold_name'))
{
    function mold_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('id'=>$id));
        return $query->first_row()->name;
    }   
}

if ( ! function_exists('mold_code'))
{
    function mold_code($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('id'=>$id));
        return $query->first_row()->code;
    }   
}

if ( ! function_exists('machine_name'))
{
    function machine_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->machine_name;
    }   
}




if ( ! function_exists('departmentLeadEmail'))
{
    function departmentLeadEmail($d_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('users',array('dpt_id'=>$d_id,'r_id'=>3));
    	if($query->num_rows() > 0){return $query->first_row()->username;}else{return false;}
    }   
}

if ( ! function_exists('issueName'))
{
    function issueName($i_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('issues',array('i_id'=>$i_id));
    	return $query->first_row()->issue;
    }   
}

if ( ! function_exists('issueDetails'))
{
    function issueDetails($i_id,$t_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	if($i_id == 47){
			$query = $ci->db->get_where('issues_other',array('t_id'=>$t_id));
			return $query->first_row()->issue_other;
		}else{
			$query = $ci->db->get_where('issues',array('i_id'=>$i_id));
			return $query->first_row()->issue;
		}
    }   
}

if ( ! function_exists('statusName'))
{
    function statusName($st_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('status',array('st_id'=>$st_id));
    	return $query->first_row()->status;
    }   
}

if ( ! function_exists('headerStatistic'))
{
    function headerStatistic()
    {
    	$ci=& get_instance();
    	$ci->load->model('user_m');
    	$data['departments'] =  $ci->user_m->getDepartments();
		$data['clients'] = 		$ci->user_m->getClients();
		$data['totaltickets'] = $ci->user_m->getTotalTickets();
		$data['cmptdtickets'] = $ci->user_m->getComplectedTickets();
		$data['pendgtickets'] = $ci->user_m->getPendingTickets();
		$data['closedtickets'] = $ci->user_m->getClosedTickets();
    	return $data;
    }   
}


if ( ! function_exists('getTickets'))
{
    function getTickets($tickets)
    {
    	$ci=& get_instance();
    	$ticketdata = array();
    	if(isset($tickets) && !empty($tickets)){
		foreach ($tickets as $ticket) {
			$creater  = user_data($ticket['creater_id']);
			if($ticket['assigned_id'] != 0){
				$assigned = user_data($ticket['assigned_id']);
				$assignedname=$assigned[0]['fullname'];
				$assigneddpt=departmentName($assigned[0]['dpt_id']);
			}else{
				$assignedname='none';
				$assigneddpt='none';
			}
			$datetime = datetimeData($ticket['dt_id']);
			if($ticket['assigned_id'] != 0){
				$assigned = user_data($ticket['assigned_id']);
				$assignedname=$assigned[0]['fullname'];
				$assigneddpt=departmentName($assigned[0]['dpt_id']);
			}else{
				$assignedname='none';
				$assigneddpt=departmentName($ticket['dpt_id']);
			}
			$ticketdata[] = array(	
							't_id'=>$ticket['t_id'],
							'title'=>$ticket['title'],
							'type'=>'ticket',
							'priority'=>priorityName($ticket['prt_id']),
							'depratment'=>departmentName($ticket['dpt_id']),
							'issue'=>issueDetails($ticket['isu_id'],$ticket['t_id']),
							'description'=>$ticket['description'],
							
							'stdate'=>$datetime[0]['stdate'],
							'sttime'=>$datetime[0]['sttime'],
							'enddate'=>$datetime[0]['enddate'],
							'endtime'=>$datetime[0]['endtime'],
							'group'=>$datetime[0]['group'],
							
							'st_id'=>$ticket['st_id'],
							'status'=>statusName($ticket['st_id']),
			
							'creater_id'=>$ticket['creater_id'],
							'creatername'=>$creater[0]['fullname'],
							'createrdpt'=>departmentName($creater[0]['dpt_id']),
			
							'assignedname'=>$assignedname,
							'assigneddpt'=>$assigneddpt,
			
							'sd'=>$ticket['sd'],
							'tm'=>$ticket['tm']
					);	
		}
    }
    	return $ticketdata;
    }   
}

if ( ! function_exists('getTask'))
{
    function getTask($tasks)
    {
    	$ci=& get_instance();
    	$taskdata = array();
    	if(isset($tasks) && !empty($tasks)){
		foreach ($tasks as $task) {
			$creater  = user_data($task['creater_id']);
			if($task['assigned_id'] != 0){
				$assigned = user_data($task['assigned_id']);
				$assignedname=$assigned[0]['fullname'];
				$assigneddpt=departmentName($assigned[0]['dpt_id']);
			}else{
				$assignedname='none';
				$assigneddpt='none';
			}
			$datetime = datetimeData($task['dt_id']);
			if($task['assigned_id'] != 0){
				$assigned = user_data($task['assigned_id']);
				$assignedname=$assigned[0]['fullname'];
				$assigneddpt=departmentName($assigned[0]['dpt_id']);
			}else{
				$assignedname='none';
				$assigneddpt=departmentName($task['dpt_id']);
			}
			$taskdata[] = array(	
							't_id'=>$task['t_id'],
							'title'=>$task['title'],
							'type'=>'task',
							'priority'=>priorityName($task['prt_id']),
							'depratment'=>departmentName($task['dpt_id']),
							'issue'=>issueName($task['isu_id']),
							'description'=>$task['description'],
							
							'stdate'=>$datetime[0]['stdate'],
							'sttime'=>$datetime[0]['sttime'],
							'enddate'=>$datetime[0]['enddate'],
							'endtime'=>$datetime[0]['endtime'],
							'group'=>$datetime[0]['group'],
							
							'st_id'=>$task['st_id'],
							'status'=>statusName($task['st_id']),
			
							'creater_id'=>$task['creater_id'],
							'creatername'=>$creater[0]['fullname'],
							'createrdpt'=>departmentName($creater[0]['dpt_id']),
			
							'assignedname'=>$assignedname,
							'assigneddpt'=>$assigneddpt
					);	
		}
    	}
    	return $taskdata;
    }   
}

if ( ! function_exists('sendMail'))
{
    function sendMail()
    {
    	$config = Array(
			  'protocol' => 'smtp',
			  'smtp_host' => 'ssl://secure.emailsrvr.com',
			  'smtp_port' => 465,
			  'smtp_user' => 'muhammad_faisal@mobilelinkusa.com', // change it to yours
			  'smtp_pass' => 'faisal@1', // change it to yours
			  'mailtype' => 'html',
			  'charset' => 'iso-8859-1',
			  'wordwrap' => TRUE
			);
		return $config;				
    }
} 

if ( ! function_exists('editRights'))
{
    function editRights($assigned_id,$creater_id)
    {
    	$ci=& get_instance();
    	if($ci->session->userdata('u_id') != $assigned_id  && ($ci->session->userdata('r_id') == 6 || $ci->session->userdata('u_id') == $creater_id) )
    	{return true;}else{return false;}	
    }
}

if ( ! function_exists('getAnnouncement'))
{
	function getAnnouncement(){
		$ci=& get_instance();
    	$ci->load->database();
    	$ci->db->select('*');
    	$ci->db->from('announcement a');
    	$ci->db->join('announcement_role ar','a.a_id=ar.a_id');
    	$ci->db->where(array('ar.r_id'=>$ci->session->userdata('r_id')));
    	$query = $ci->db->get();
    	if($query->num_rows() > 0) return $query->last_row()->message;
	}
}
if ( ! function_exists('ticketAttachment'))
{
    function ticketAttachment($t_id)
    {
    	$ci=& get_instance();
    	if($ci->db->get_where('ticketdocu',array('t_id'=>$t_id))->num_rows() > 0)
    	{return true;}else{return false;}	
    }
}

if ( ! function_exists('getmarkets'))
{
    function getmarkets()
    {
    	$ci=& get_instance();
    	return $ci->db->order_by('marketname', 'ASC')->get('markets')->result_array(); 
    }
}

if(! function_exists('getstore'))
{
	
	function getstore()
	{
		$ci=& get_instance();
		return $ci->db->get('stores')->result_array();
		///$query = $this->db->get_where('mytable', array('id' => $id), $limit, $offset);
	}
	
}
if(!function_exists('storeaddress')){
	function storeaddress($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('store', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->address;}
	}
}


if ( ! function_exists('storeStatus'))
{
    function storeStatus($storeid)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('signup',array('d_id'=>$storeid));
    	return $query->first_row()->dep_name;
    }   
}

if ( ! function_exists('getLeaseId'))
{
    function getLeaseId($storeid)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('signup',array('storeid'=>$storeid));
    	if($query->num_rows() > 0){
				return $query->first_row()->leaseid;
		}else{
			return '';
		}
		
    }  
}	
	
	if ( ! function_exists('getLeasedata'))
	{
	    function getLeasedata($storeid)
	    {
			$ci=& get_instance();
	    	$ci->load->database();
	    	$query = $ci->db->get_where('lease',array('s_id'=>$storeid));
	    	if($query->num_rows() > 0){
					return $query->result_array();;
			}else{
				return false;
			}
		} 
	}
	
	if ( ! function_exists('getLocation'))
	{
    function getLocation($leaseid)
    {
		
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('location',array('leaseid'=>$leaseid));
    	if($query->num_rows() > 0){
				return $query->result_array();
		}else{
			return '';
		}
		
    } 
	
	
	}
	
	
	
	if ( ! function_exists('getArea'))
	{
    function getArea($leaseid)
    {
		
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('area',array('leaseid'=>$leaseid));
    	if($query->num_rows() > 0){
				return $query->result_array();
		}else{
			return '';
		}
		
    } 
	
	
	}
	
	if ( ! function_exists('marketname'))
{
    function marketname($m_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('markets',array('m_id'=>$m_id));
		if($query->num_rows() > 0){
    	return $query->first_row()->marketname;
    }else{
		
		return '';
		
	}
	}	
}


if ( ! function_exists('storename'))
{
    function storename($s_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('store',array('s_id'=>$s_id));
		if($query->num_rows() > 0){
    	return $query->first_row()->store;
    }else{
		
		return '';
		
	}
	}	
}

if ( ! function_exists('uniqueid'))
{
    function uniqueid($sid)
    {
    	$ci=& get_instance();
    	$ci ->load->database();
		$ci->db->where('s_id',$sid);
		$result = $ci->db->get('store');
		if($result->num_rows() >0)
		{
			
			return $result->first_row()->uid;
		}else{
			return false;
}
	}
}
if ( ! function_exists('area'))
{
    function area($sid)
    {
    	$ci=& get_instance();
    	$ci ->load->database();
		$ci->db->where('s_id',$sid);
		$result = $ci->db->get('store');
		if($result->num_rows() >0)
		{
			
			return $result->first_row()->area;
		}else{
			return false;
}
	}
}

if(! function_exists('stdate')){
		function stdate($l_id){
				$ci=& get_instance();
				$ci->load->database();
				$ci->db->where('l.l_id',$l_id);
				$ci->db->where('r.stdate <=',date("Y-m-d"));
				$ci->db->where('r.enddate >=',date("Y-m-d"));
				$result1 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
				if($result1->num_rows() >0){
					return $result1->first_row()->stdate;
				}else{
	              	$ci=& get_instance();
					$ci->load->database();
					$ci->db->where('l.l_id',$l_id);
					$ci->db->where('r.stdate <',date("Y-m-d"));
					$ci->db->where('r.enddate <',date("Y-m-d"));
					$result2 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
					if($result2->num_rows() >0){
						return $result2->last_row()->stdate;
					}else{
						$ci=& get_instance();
						$ci->load->database();
						$ci->db->where('l.l_id',$l_id);
						$ci->db->where('r.stdate >',date("Y-m-d"));
						$ci->db->where('r.enddate >',date("Y-m-d"));
						$result3 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
						if($result3->num_rows() > 0){
							return $result3->first_row()->stdate;
						}else{
							return 0.00;
						}

					}
	          }
		}
}
if(! function_exists('enddate')){
		function enddate($l_id){
				$ci=& get_instance();
				$ci->load->database();
				$ci->db->where('l.l_id',$l_id);
				$ci->db->where('r.stdate <=',date("Y-m-d"));
				$ci->db->where('r.enddate >=',date("Y-m-d"));
				$result1 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
				if($result1->num_rows() >0){
					return $result1->first_row()->enddate;
				}else{
	              	$ci=& get_instance();
					$ci->load->database();
					$ci->db->where('l.l_id',$l_id);
					$ci->db->where('r.stdate <',date("Y-m-d"));
					$ci->db->where('r.enddate <',date("Y-m-d"));
					$result2 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
					if($result2->num_rows() >0){
						return $result2->last_row()->enddate;
					}else{
						$ci=& get_instance();
						$ci->load->database();
						$ci->db->where('l.l_id',$l_id);
						$ci->db->where('r.stdate >',date("Y-m-d"));
						$ci->db->where('r.enddate >',date("Y-m-d"));
						$result3 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
						if($result3->num_rows() > 0){
							return $result3->first_row()->enddate;
						}else{
							return 0.00;
						}

					}
	          }
		}
}
if(! function_exists('rent')){
		function rent($l_id){

	            $ci=& get_instance();
				$ci->load->database();
				$ci->db->where('l.l_id',$l_id);
				$ci->db->where('r.stdate <=',date("Y-m-d"));
				$ci->db->where('r.enddate >=',date("Y-m-d"));
				$result1 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
				if($result1->num_rows() >0){
					return $result1->first_row()->rent;
				}else{

	              	$ci=& get_instance();
					$ci->load->database();
					$ci->db->where('l.l_id',$l_id);
					$ci->db->where('r.stdate <',date("Y-m-d"));
					$ci->db->where('r.enddate <',date("Y-m-d"));
					$result2 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
					if($result2->num_rows() >0){
						return $result2->last_row()->rent;
					}else{
						$ci=& get_instance();
						$ci->load->database();
						$ci->db->where('l.l_id',$l_id);
						$ci->db->where('r.stdate >',date("Y-m-d"));
						$ci->db->where('r.enddate >',date("Y-m-d"));
						$result3 = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
						if($result3->num_rows() > 0){
							return $result3->first_row()->rent;
						}else{
							return 0.00;
						}

					}
	         }
		}
}


if ( ! function_exists('area'))
{
    function area($sid)
    {
    	$ci=& get_instance();
    	$ci ->load->database();
		$ci->db->where('s_id',$sid);
		$result = $ci->db->get('store');
		if($result->num_rows() >0)
		{
			
			return $result->first_row()->area;
		}else{
			return false;
}
	}
}

if ( ! function_exists('markets'))
{
    function markets($m_id)
    {
    	$ci=& get_instance();
    	$ci ->load->database();
		$ci->db->where('m_id',$m_id);
		$result = $ci->db->get('markets');
		if($result->num_rows() >0)
		{
			
			return $result->first_row()->marketname;
		}else{
			return false;
}
	}
}

if(! function_exists('storedata'))
{
	function storedata($s_id)
	{
	$ci=& get_instance();
	$ci->load->database();
	$ci->db->where('s_id',$s_id);
	$result = $ci->db->get('store');
	if($result->num_rows() >0)
	{
		return $result->result_array();
		
	}else{
		
		return false;
	}
	}
	
}

if(! function_exists('leasedata'))
{
	function leasedata($s_id)
	{
	$ci=& get_instance();
	$ci->load->database();
	//$ci->db->where('s_id',$s_id);
	//$result = $ci->db->get('lease');
	$ci->db->where('l.s_id',$s_id);
	$ci->db->where('r.default',1);
	$ci->db->or_where('l.s_id',$s_id);
	$ci->db->where('r.default',0);
	$result = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
	
	if($result->num_rows() >0)
	{
		return $result->result_array();
		
	}else{
		
		return false;
	}
	}
	
}

if(! function_exists('leaseBaseRent'))
{
	function leaseBaseRent($s_id)
	{
	$ci=& get_instance();
	$ci->load->database();
	//$ci->db->where('s_id',$s_id);
	//$result = $ci->db->get('lease');
	$ci->db->where('l.s_id',$s_id);
	//$ci->db->where('r.default',1);
	$result = $ci->db->select('*')->from('lease l')->join('leasebaserent r', 'l.l_id=r.l_id')->get();
	
	if($result->num_rows() >0)
	{
		return $result->result_array();
		
	}else{
		
		return false;
	}
	}
	
}
if (! function_exists('servicedata'))
{
	function servicedata($s_id)
	{
		$ci= & get_instance();
		$ci->load->database();
		$ci->db->where('s_id',$s_id);
		$result = $ci->db->get('store');
		if($result->num_rows() >0)
		{
			return $result->first_row()->uid;
			
		}else{
			return false;
}
	
}
}

if (! function_exists('leasestatus'))
{
	function leasestatus($s_id)
	{
		$ci= & get_instance();
		$ci->load->database();
		$ci->db->where('s_id',$s_id);
		$result = $ci->db->get('lease');
		if($result->num_rows() >0)
		{
			return $result->first_row()->status;
			
		}else{
			return false;
}
	
}
}


if (! function_exists('leasestatus_l_id'))
{
	function leasestatus_l_id($l_id)
	{
		$ci= & get_instance();
		$ci->load->database();
		$ci->db->where('l_id',$l_id);
		$result = $ci->db->get('lease');
		if($result->num_rows() >0)
		{
			return $result->first_row()->status;
			
		}else{
			return false;
}
	
}
}
if (! function_exists('leaseType'))
{
	function leaseType($l_id)
	{
		$ci= & get_instance();
		$ci->load->database();
		$ci->db->where('l_id',$l_id);
		$result = $ci->db->get('lease');
		if($result->num_rows() >0)
		{
			return $result->first_row()->type;
			
		}else{
			return false;
}
	
}
}

if ( ! function_exists('SDname'))
{
    function SDname($sd)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('user',array('u_id'=>$sd));
		if($query->num_rows() > 0){
    	return $query->first_row()->uname;
    }else{
		
		return '';
		
	}
	}	
}

if ( ! function_exists('TMname'))
{
    function TMname($tm)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('user',array('u_id'=>$tm));
		if($query->num_rows() > 0){
    	return $query->first_row()->uname;
    }else{
		
		return '';
		
	}
	}	
}

if ( ! function_exists('RSMname'))
{
    function RSMname($rsm)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('user',array('u_id'=>$rsm));
		if($query->num_rows() > 0){
    		return $query->first_row()->uname;
	    }else{
			return '';
		}
	}	
}

if(! function_exists('leaseImage'))
{
	function leaseImage($l_id) {
		$ci = &get_instance();
		$ci->load->database();
		$query = $ci->db->get_where('leaseimage', array('l_id'=>$l_id));
		if($query->num_rows() > 0){
			return $query->first_row()->name;
		}else{
			return false;
		}
	}
}

if ( ! function_exists('checkLease'))
{
	function checkLease($s_id)
	{
		$ci=& get_instance();
		$ci->load->database();
		$query = $ci->db->get_where('lease',array('s_id'=>$s_id));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}
}

if(! function_exists('checkStatus'))
{
	function checkStatus($id, $tablename) {
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where($tablename, array('m_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->status;}
	}		
}

if(! function_exists('checkStatusStore'))
{
	function checkStatusStore($id, $tablename) {
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where($tablename, array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->status;}
	}
}
if(! function_exists('statusStore'))
{
	function statusStore($id, $tablename) {
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where($tablename, array('s_id'=>$id));
		if($result->num_rows() > 0){
           if($result->first_row()->status == "true"){
            return "Active";
           }else if($result->first_row()->status == "false"){
 			return  "Closed";
           }else if($result->first_row()->status == "Possession"){
           	return "Possession";
           }else if($result->first_row()->status == "NotOpen"){
           	return "Not Open";
           }

		}
	}
}

if(!function_exists('contractorName')){
	function contractorName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('contractor', array('id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->name;}
	}
}

if(!function_exists('contractorLists')){
	function contractorLists($id){
		$ci = & get_instance();
		$ci->load->database();
		$ctr_name = contractorName($id);
		$result = $ci->db->get_where('contractor', array('name'=>$ctr_name));
		if($result->num_rows() > 0){return $result->result_array();}else{return false;}
	}
}

if(!function_exists('dealerName')){
	function dealerName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('dealer', array('id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->name;}
	}
}


if(!function_exists('dealerLists')){
	function dealerLists($id){
		$ci = & get_instance();
		$ci->load->database();
		$dlr_name = dealerName($id);
		$result = $ci->db->get_where('dealer', array('name'=>$dlr_name));
		if($result->num_rows() > 0){return $result->result_array();}else{return false;}
	}
}

if(!function_exists('landLName')){
	function landLName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->name;}
	}
}

if(!function_exists('landLordName')){
	function landLordName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('ld_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->company;}
	}
}


if(!function_exists('landLordaddress')){
	function landLordaddress($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('ld_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->address;}
	}
}


if(!function_exists('landLordcity')){
	function landLordcity($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('ld_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->city;}
	}
}



if(!function_exists('landLordzip')){
	function landLordzip($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('ld_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->zip;}
	}
}



if(!function_exists('landLordstate')){
	function landLordstate($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('ld_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->country;}
	}
}




if(!function_exists('landLordName_S_ID')){
	function landLordName_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->name;}
	}
}
if(!function_exists('landLordCompany_S_ID')){
	function landLordCompany_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->company;}
	}
}


if(!function_exists('landLordaddress_S_ID')){
	function landLordaddress_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->address;}
	}
}


if(!function_exists('landLordcity_S_ID')){
	function landLordcity_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->city;}
	}
}




if(!function_exists('landLordzip_S_ID')){
	function landLordzip_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->zip;}
	}
}
if(!function_exists('landLordPhone_S_ID')){
	function landLordPhone_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->phone;}
	}
}
if(!function_exists('landLordFax_S_ID')){
	function landLordFax_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->fax;}
	}
}



if(!function_exists('landLordstate_S_ID')){
	function landLordstate_S_ID($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->country;}
	}
}


if(!function_exists('rentpaymentName')){
	function rentpaymentName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->name;}
	}
}
if(!function_exists('rentpaymentCompany')){
	function rentpaymentCompany($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->company;}
	}
}
if(!function_exists('rentpaymentAddress')){
	function rentpaymentAddress($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->address;}
	}
}
if(!function_exists('rentpaymentCity')){
	function rentpaymentCity($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->city;}
	}
}
if(!function_exists('rentpaymentState')){
	function rentpaymentState($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->country;}
	}
}
if(!function_exists('rentpaymentZip')){
	function rentpaymentZip($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->zip;}
	}
}
if(!function_exists('rentpaymentPhone')){
	function rentpaymentPhone($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->phone;}
	}
}
if(!function_exists('rentpaymentFax')){
	function rentpaymentFax($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('rentpayment', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->fax;}
	}
}

if(!function_exists('dateFormat')){
	function dateFormat($date){
		$date = explode("-",$date); echo $date[1].'-'.$date[2].'-'.$date[0];
		return $date;
	}
}





if(!function_exists('landLordName')){
	function landLordName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('landloard', array('ld_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->company;}
	}
}

if(!function_exists('landlordLists')){
	function landlordLists($id){
		$ci = & get_instance();
		$ci->load->database();
		$ladlrd_name = landLordName($id);
		$result = $ci->db->get_where('landloard', array('company'=>$ladlrd_name));
		if($result->num_rows() > 0){return $result->result_array();}else{return false;}
	}
}


if(!function_exists('proManagerName')){
	function proManagerName($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('promanager', array('pm_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->company;}
	}
}

if(!function_exists('proManagerLists')){
	function proManagerLists($id){
		$ci = & get_instance();
		$ci->load->database();
		$prm_name = proManagerName($id);
		$result = $ci->db->get_where('promanager', array('company'=>$prm_name));
		if($result->num_rows() > 0){return $result->result_array();}else{return false;}
	}
}

if(!function_exists('emailStatus')){
	function emailStatus($l_id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('lease', array('l_id'=>$l_id));
		if($result->first_row()->emailstatus == 'notsent' && $result->first_row()->expdate >= date("Y-m-d")){
			return true;	
		}else{
			return false;
		}
	}
}

	/* Start Fatch Lease utilityes  */
	if(! function_exists('leaseservicese')){
		function leaseservicese($s_id){
			$ci=& get_instance();
			$ci->load->database();
			$ci->db->where('l.s_id',$s_id);
			$result = $ci->db->select('*')->from('lease l')->join('leaseservices r', 'l.l_id=r.l_id')->get();
			if($result->num_rows() >0){
				return $result->result_array();
			}else{
				return false;
			}
		}
	}
	/* End Fatch Lease utilityes  */
	/* Start Fatch Lease maintenance  */
	if(! function_exists('leasemaintenances')){
		function leasemaintenances($s_id){
			$ci=& get_instance();
			$ci->load->database();
			$ci->db->where('l.s_id',$s_id);
			$result = $ci->db->select('*')->from('lease l')->join('leasemaintenance m', 'l.l_id=m.l_id')->get();
			if($result->num_rows() >0){
				return $result->result_array();
			}else{
				return false;
			}
		}
	}
	/* End Fatch Lease maintenance  */
	
	/* Start Fatch Lease utilityes  */
	if(! function_exists('leaseNNNServices')){
		function leaseNNNServices($s_id){
			$ci=& get_instance();
			$ci->load->database();
			$ci->db->where('l.s_id',$s_id);
			$result = $ci->db->select('*')->from('lease l')->join('leasennnservices nn', 'l.l_id = nn.l_id')->get();
			if($result->num_rows() >0){
				return $result->result_array();
			}else{
				return false;
			}
		}
	}
	/* End Fatch Lease utilityes  */
	
	if(!function_exists('leaseadditionals')){
	function leaseadditionals($id){
		$ci = & get_instance();
		$ci->load->database();
		//$result = $ci->db->select('*')->from('lease l')->join('leaseadditional lt', 'l.l_id=lt.l_id')->get();
		$result = $ci->db->get_where('leaseadditional', array('l_id'=>$id));		
		if($result->num_rows() > 0)
		{return $result->result_array();}
	}
	
}
	
	
	
	/* Start End Lease Additional */
	
	/* Start securityDeposit */
	if(!function_exists('securityDeposit')){
		function securityDeposit($l_id){
			$ci = & get_instance();
			$ci->load->database();
			$result = $ci->db->get_where('leasesecuritydeposit', array('l_id'=>$l_id));
			if($result->num_rows() > 0){return $result->result_array();}
		}
	}	
	/* Start securityDeposit */
	
	/* Start Prepaid Amount */
	if(!function_exists('prepaidAmount')){
		function prepaidAmount($l_id){
			$ci = & get_instance();
			$ci->load->database();
			$result = $ci->db->get_where('leaseprepaidrent', array('l_id'=>$l_id));
			if($result->num_rows() > 0){return $result->result_array();}
		}
	}	
	/* Start Prepaid Amount */
	/* Start Prepaid Amount */
	if(!function_exists('leaseData')){
		function leaseData($l_id){
			$ci = & get_instance();
			$ci->load->database();
			$result = $ci->db->get_where('lease', array('l_id'=>$l_id));
			if($result->num_rows() > 0){return $result->result_array();}
		}
	}	
	/* Start Prepaid Amount */
	/* Start Prepaid Amount */
	if(!function_exists('leaseStoreID')){
		function leaseStoreID($s_id){
			$ci = & get_instance();
			$ci->load->database();
			$result = $ci->db->get_where('lease', array('s_id'=>$s_id));
			if($result->num_rows() > 0){return $result->result_array();}
		}
	}	
	/* Start Prepaid Amount */
	/* Start Fatch Lease utilityes  */
	if(! function_exists('rentpayment')){
		function rentpayment($s_id){
			$ci=& get_instance();
			$ci->load->database();
			$ci->db->where('s.s_id',$s_id);
			$result = $ci->db->select('*')->from('store s')->join('rentpayment rp', 's.s_id = rp.s_id')->get();
			if($result->num_rows() >0){
				return $result->result_array();
			}else{
				return false;
			}
		}
	}
	
	if(!function_exists('fileno')){
	function fileno($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('lease', array('s_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->fileno;}
	}
	}
	
	if(!function_exists('pro_rata1')){
	function pro_rata1($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Pro_rata'));
		if($result->num_rows() > 0){return $result->first_row()->name;}
	}
	
}
if(!function_exists('pro_rata2')){
	function pro_rata2($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Pro_rata'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}
if(!function_exists('Utility')){
	function Utility($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Utility'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}

if(!function_exists('renewalall')){
		function renewalall($l_id){
			$ci = & get_instance();
			$ci->load->database();
			$result = $ci->db->get_where('leaserenewal', array('l_id'=>$l_id));
			if($result->num_rows() > 0){return $result->result_array();}
		}
	}


if(!function_exists('terminationall')){
		function terminationall($l_id){
			$ci = & get_instance();
			$ci->load->database();
			$result = $ci->db->get_where('leaseearlytermination', array('l_id'=>$l_id));
			if($result->num_rows() > 0){return $result->result_array();}
		}
	}




if(!function_exists('nnnleaseamount')){
	function nnnleaseamount($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->result_array();}else{
			return false;
		}
	}
	
}


if(!function_exists('resposible_des')){
	function resposible_des($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemaintenance', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->description;}
	}
	
}


if(!function_exists('resposible_maintenance')){
	function resposible_maintenance($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemaintenance', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->result_array();}else{
			return false;
		}
	}
	
}
if(!function_exists('resposible_utility')){
	function resposible_utility($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->result_array();}else{
			return false;
		}
	}
	
}


/*  if(!function_exists('renewal')){
	function renewal($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where(' leaserenewal', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->result_array();}else{
			return false;
		}
	}
	
}  */

if(!function_exists('security')){
	function security($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasesecuritydeposit', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->sd_amount;}
	}
	
}


if(!function_exists('all_security')){
	function all_security($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasesecuritydeposit', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->result_array();}else{
			return false;
		}
	}
	
}


if(!function_exists('all_prepaid')){
	function all_prepaid($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseprepaidrent', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->result_array();}else{
			return false;
		}
	}
	
}


if(!function_exists('prepaid')){
	function prepaid($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseprepaidrent', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->pr_amount;}
	}
	
}


if(!function_exists('tax1')){
	function tax1($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Tax'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}
if(!function_exists('plyon1')){
	function plyon1($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Pylon'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}
if(!function_exists('Marketing1')){
	function Marketing1($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Marketing'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}
if(!function_exists('U_O')){
	function U_O($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'U&O'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}
if(!function_exists('Misc_Others')){
	function Misc_Others($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Misc/Others'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}


if(!function_exists('insurance')){
	function insurance($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Insurance'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}

if(!function_exists('CAM')){
	function CAM($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'CAM'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}
if(! function_exists('other')){
		function other($l_id){
			$ci=& get_instance();
			$ci->load->database();



			$result = $ci->db->select('SUM(n.lnnns_amount) AS amount', FALSE)->from('lease l')->join('leasennnservices n', 'l.l_id=n.l_id')->where('l.l_id',$l_id)->get();
			if($result->num_rows() >0){
				return $result->first_row()->amount - CAM($l_id) - tax1($l_id) - insurance($l_id);
			}else{
				return false;
			}
		}
}


if(!function_exists('totalrent')){
	function totalrent($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasebaserent', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->totalrent;}
	}
}


/*if(!function_exists('other')){
	function other($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id,'name'=>'Other'));
		if($result->num_rows() > 0){return $result->first_row()->lnnns_amount;}
	}
	
}*/




if(!function_exists('Pylon_term')){
	function Pylon_term($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseadditional', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->plyon;}
	}
	
}


if(!function_exists('term')){
	function term($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseadditional', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->term;}
	}
	
}

if(!function_exists('TI')){
	function TI($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasennnservices', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->tia_amount;}
	}
	
}


if(!function_exists('maintenance_HVAC')){
	function maintenance_HVAC($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemaintenance', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}


if(!function_exists('maintenance_electrical')){
	function maintenance_electrical($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemaintenance', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}


if(!function_exists('maintenance_plumbing')){
	function maintenance_plumbing($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemaintenance', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('maintenance_plumbing')){
	function maintenance_plumbing($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemaintenance', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('leaseservicespenalty_name')){
	function leaseservicespenalty_name($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservicespenalty', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->lsp_name;}
	}
	
}
if(!function_exists('leaseservicespenalty_amount')){
	function leaseservicespenalty_amount($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservicespenalty', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->lsp_amount;}
	}
	
}
if(!function_exists('leaseservicespenalty_description')){
	function leaseservicespenalty_description($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservicespenalty', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->lsp_description;}
	}
	
}
if(!function_exists('leasemanagementfee_name')){
	function leasemanagementfee_name($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemanagementfee', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->lf_name;}
	}
	
}
if(!function_exists('leasemanagementfee_amount')){
	function leasemanagementfee_amount($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemanagementfee', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->lf_amont;}
	}
	
}
if(!function_exists('leasemanagementfee_description')){
	function leasemanagementfee_description($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leasemanagementfee', array('l_id'=>$id));
		if($result->num_rows() > 0){return $result->first_row()->lf_description;}
	}
	
}


if(!function_exists('leaseserviceswater')){
	function leaseserviceswater($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Water'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('leaseservicesSewer')){
	function leaseservicesSewer($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Sewer'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('leaseservicesWaste_Trash')){
	function leaseservicesWaste_Trash($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Waste_Trash'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('leaseservicesPhone_Internet')){
	function leaseservicesPhone_Internet($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Phone_Internet'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('leaseservicesWaste_Trash')){
	function leaseservicesWaste_Trash($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Waste_Trash'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}

if(!function_exists('leaseservicesProperty_Maintenance')){
	function leaseservicesProperty_Maintenance($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Property_Maintenance'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}
if(!function_exists('leaseservicestrash')){
	function leaseservicestrash($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Trash'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}


if(!function_exists('leaseservicesgas')){
	function leaseservicesgas($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Gas'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}


if(!function_exists('leaseserviceselectric')){
	function leaseserviceselectric($id){
		$ci = & get_instance();
		$ci->load->database();
		$result = $ci->db->get_where('leaseservices', array('l_id'=>$id,'name'=>'Electricity'));
		if($result->num_rows() > 0){return $result->first_row()->rights;}
	}
	
}



if ( ! function_exists('clerence_match'))
{
    function clerence_match($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select(' line_clerence.production_id as production_id_clear');
       $ci->db->from(' line_clerence');
       $ci->db->where('production_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->production_id_clear;
    }   
}


	/* End Fatch Lease utilityes  */

