<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Rizwan </title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo base_url(); ?>assets/images/favicon.png">
    <link rel="stylesheet"
        href="<?php echo base_url(); ?>assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/style.css">
    <!-- Pick date -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/pickadate/themes/default.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/pickadate/themes/default.date.css">
    <link href="<?php echo base_url(); ?>assets/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <!-- Custom Stylesheet -->
</head>

<body>
    <div id="preloader">
        <div class="sk-three-bounce">
            <div class="sk-child sk-bounce1"></div>
            <div class="sk-child sk-bounce2"></div>
            <div class="sk-child sk-bounce3"></div>
        </div>
    </div>
    <div id="main-wrapper">
        <?php $this->load->view('header'); ?>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Advance Loan</h4>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Employees</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Add Employees</a></li>
                        </ol>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Pay Loan/Advance</h4>
                            </div>
                            

                            <div class="card-body">
                                <!-- Display success message only once -->
                                <?php if (isset($flash_success)): ?>
                                    <div class="alert alert-success"><?= $flash_success ?></div>
                                <?php endif; ?>

                                <!-- Display validation errors if there are any -->
                                <?= validation_errors('<div class="alert alert-danger">', '</div>'); ?>

                                <!-- Form for submitting advance/loan -->
                                <h4>Loan Summary</h4>
                                <ul>
                                    <li>Total Loan: Rs. <?= number_format($loan->amount, 2) ?></li>
                                    <li>Total Paid: Rs. <?= number_format($total_paid, 2) ?></li>
                                    <li><strong>Due Balance: Rs. <?= number_format($due_balance, 2) ?></strong></li>
                                </ul>

                                <form method="post">
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label>Pay Amount</label>
                                            <input type="number" name="amount" class="form-control" min="1" required>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label>Comments</label>
                                            <textarea name="comments" class="form-control"></textarea>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-success">Submit Payment</button>
                                </form>

                                <hr>

                                <h5>Payment History</h5>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>#</th>
                                        <th>Amount</th>
                                        <th>Comments</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($payments as $i => $p): ?>
                                        <tr>
                                            <td><?= $i + 1 ?></td>
                                            <td>Rs. <?= number_format($p->amount, 2) ?></td>
                                            <td><?= $p->comments ?></td>
                                            <td><?= date('d-m-Y H:i', strtotime($p->created_at)) ?></td>
                                            <td><a href="<?= base_url('Admin/edit_advance_pay/' . $p->id) ?>" class="btn btn-sm btn-warning">Edit</a></td>

                                        </tr>
                                        
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>


                                <hr class="my-4">

                            </div>



                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="footer">
            <div class="copyright">
                <p>Copyright © Designed &amp; Developed by 2020</p>
            </div>
        </div>

    </div>

    <?php $this->load->view('footer'); ?>

</body>

<!-- Mirrored from edumin.dexignlab.com/xhtml/add-departments.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 17 Nov 2020 13:56:15 GMT -->

</html>