<style>
  #container {
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
    font-family: 'Segoe UI', sans-serif;
  }

  h3 {
    margin-bottom: 20px;
    font-weight: 600;
    color: #333;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    min-width: 900px;
  }

  thead th {
    background-color: #4F9A94;
    color: #fff;
    padding: 12px;
    text-align: center;
    font-size: 14px;
  }

  tbody td {
    padding: 10px;
    text-align: center;
    font-size: 13px;
    border: 1px solid #dee2e6;
  }

  tbody tr:nth-child(even) {
    background-color: #f8f9fa;
  }

  tbody tr:hover {
    background-color: #eef6f6;
  }

  .status-late {
    background-color: #ff4d4d;
    color: #fff;
    font-weight: bold;
  }

  .status-ontime {
    background-color: #71a72b;
    color: #fff;
    font-weight: bold;
  }

  .summary span {
    display: inline-block;
    margin: 8px 20px 0 0;
    font-size: 14px;
    color: #444;
  }
  .summary strong {
    color: #222;
  }
</style>
<!-- <button class="btn btn-warning" onclick="printData1();">Print me</button> -->
<div class="table-responsive" id="container">
<img class="mr-3 rounded" alt="image" width="100" src="<?php echo base_url('assets/images/profile/' . images($filter_data[0]['emp_id'])); ?>">
  <h5><?php echo fullname($filter_data[0]['emp_id']); ?></h5>

  <table>
    <thead>
        <tr>
            <th>Date</th>
            <th>Time IN</th>
            <th>Time Out</th>
            <th>Status</th>
            <th>Over Time Hours</th>
            <th>Over Time Pay</th>
            <th>Tea/Petrol</th>
        </tr>
    </thead>
    <tbody>
      <?php
      $total_price = 0;
      $total_adv = 0;
      $datecounter = 0;

      if (!empty($filter_data)) {
          foreach ($filter_data as $value) {
              $date = date("d-m-Y", strtotime($value['date']));
              $tap_in = $value['tap_in'] ? date("g:i a", strtotime($value['tap_in'])) : "-";
              $tap_out = $value['tap_out'] ? date("g:i a", strtotime($value['tap_out'])) : "-";

              $scheduled_in = date('H:i:s', strtotime(get_emp_tap_in($value['emp_id'])));
              $scheduled_out = date('H:i:s', strtotime(get_emp_tap_out($value['emp_id'])));
              $actual_in = $value['tap_in'] ? date('H:i:s', strtotime($value['tap_in'])) : null;
              $actual_out = $value['tap_out'] ? date('H:i:s', strtotime($value['tap_out'])) : null;


              $scheduled_in_time = strtotime($scheduled_in);
              $scheduled_out_time = strtotime($scheduled_out);
              $actual_in_time = strtotime($actual_in);
              $actual_out_time = strtotime($actual_out);



              $is_late = false;

              
              if ($actual_in && $actual_in_time > $scheduled_in_time) {
                  $is_late = true;
              }

              // If tap out is missing and date is in the past, mark as late
              $record_date = date('Y-m-d', strtotime($value['date']));
              $current_date = date('Y-m-d');
              if (empty($actual_out) && $record_date < $current_date) {
                  $is_late = true;
              }

              $status_text = $is_late ? "Late" : "On Time";
              $status_class = $is_late ? "status-late" : "status-ontime";

             
              $worked_seconds = $actual_out_time - $actual_in_time;
              $scheduled_work_seconds = $scheduled_out_time - $scheduled_in_time;

              // Only give OT if employee was not late
              $ot = "00:00";
              $ot_hours = 0;
              $ot_amount = 0;

              $overtime_rate = over_time($value['emp_id']);

              if (!$is_late && $actual_out_time > $scheduled_out_time) {
                  // Only count overtime after scheduled out
                  $ot_seconds = $actual_out_time - $scheduled_out_time;
                  $ot_hours = floor($ot_seconds / 3600);
                  $ot_minutes = floor(($ot_seconds % 3600) / 60);
                  $ot = sprintf('%02d:%02d', $ot_hours, $ot_minutes);
                  $ot_amount = $overtime_rate
                      ? ($overtime_rate * $ot_hours) + ($overtime_rate * ($ot_minutes / 60))
                      : 0;
              }



              $adv = $value['advance'] ?: "-";
              $total_price += $ot_hours;
              $total_adv += $value['advance'];
              $datecounter++;
              ?>
              <tr>
                  <td><?= $date; ?></td>
                  <td><?= $tap_in; ?></td>
                  <td><?= $tap_out; ?></td>
                  <td class="<?= $status_class; ?>"><b><?= $status_text; ?></b></td>
                  <td><?= $ot; ?></td>
                  <td>
                      <?php
                      $overtime_rate = over_time($value['emp_id']);

                     if ($overtime_rate && !$is_late && $worked_seconds > $scheduled_work_seconds) {
                      $ot_seconds = $worked_seconds - $scheduled_work_seconds;
                      $ot_hours = floor($ot_seconds / 3600);
                      $ot_minutes = round(($ot_seconds % 3600) / 60);
                      $ot_amount = ($overtime_rate * $ot_hours) + ($overtime_rate * ($ot_minutes / 60));
                      echo "Rs " . number_format($ot_amount, 2);
                  } else {
                      echo "Rs 0.00";
                  }




                      ?>
                  </td>
                  <td><?= number_format(tea_petrol($value['emp_id']), 2); ?></td>
              </tr>
              <?php
                  }
              }

              
              ?>

             

        </tbody>

    </table>


  <!-- <div class="summary mt-4">
    <span><strong>Salary:</strong> Rs/= <?php echo salary_emp($value['emp_id']); ?></span>
    <span><strong>Presents:</strong> <?php echo $datecounter; ?></span>
    <br><br>
    <span><strong>Advance:</strong> Rs/= <?php echo $total_adv; ?></span>
    <span><strong>Over Time:</strong> <?php echo $total_price; ?></span>
  </div>
</div> -->


<script type="text/javascript">

    function printData1() {
        var divToPrint = document.getElementById("container");
        newWin = window.open("");
        newWin.document.write(divToPrint.outerHTML);
        newWin.print();
        newWin.close();
    }
</script>