<!DOCTYPE html>
<html>
<head>
    <title>Edit Advance/Loan</title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css'); ?>">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/vendor/pickadate/themes/default.css">
<link rel="stylesheet" href="<?= base_url(); ?>assets/vendor/pickadate/themes/default.date.css">
<script src="<?= base_url(); ?>assets/vendor/pickadate/picker.js"></script>
<script src="<?= base_url(); ?>assets/vendor/pickadate/picker.date.js"></script>

</head>
<body>

    <div id="main-wrapper">
        <?php $this->load->view('header'); ?>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Employees</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Add Employees</a></li>
                        </ol>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Edit Advance/Loan Request</h4>
                            </div>
                            <div class="card-body">
                               <?php if ($this->session->flashdata('success')): ?>
                                <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
                               <?php unset($_SESSION['success']); ?>
                                <?php endif; ?>


                            <?= validation_errors('<div class="alert alert-danger">', '</div>'); ?>

                            <form method="post" action="<?= base_url('Admin/update_advance_pay') ?>">
                            <input type="hidden" name="id" value="<?= $payment->id ?>">

                            <div class="form-group">
                                <label>Amount</label>
                                <input type="number" name="amount" class="form-control" value="<?= (int)$payment->amount ?>" required min="1">
                            </div>

                            <div class="form-group">
                                <label>Date</label>
                                <input type="date" name="created_at" class="form-control" value="<?= date('Y-m-d', strtotime($payment->created_at)) ?>" required>
                            </div>

                            <button type="submit" class="btn btn-success">Update</button>
                            <a href="<?= base_url('Admin/pay_advance_loan/'.$payment->parent_id) ?>" class="btn btn-secondary">Cancel</a>
                        </form>

                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="footer">
            <div class="copyright">
                <p>Copyright © Designed &amp; Developed by 2020</p>
            </div>
        </div>

    </div>
 <?php $this->load->view('footer'); ?>

</body>

<script>
    $(document).ready(function(){
        $('input[name="created_at"]').pickadate({
            format: 'yyyy-mm-dd',
            selectMonths: true,
            selectYears: true
        });
    });
</script>

</html>
