<!DOCTYPE html>
<html>

<head>
    <title>Edit Advance/Loan</title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css'); ?>">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/vendor/pickadate/themes/default.css">
    <link rel="stylesheet" href="<?= base_url(); ?>assets/vendor/pickadate/themes/default.date.css">
    <script src="<?= base_url(); ?>assets/vendor/pickadate/picker.js"></script>
    <script src="<?= base_url(); ?>assets/vendor/pickadate/picker.date.js"></script>

</head>

<body>

    <div id="main-wrapper">
        <?php $this->load->view('header'); ?>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">

                        <div class="sorting_1">
                            <img class="mr-3 rounded" alt="image" width="120"
                                src="<?php echo base_url('assets/images/profile/' . images($emp_id)); ?>">
                        </div>
                        <h3><?php echo fullname($emp_id); ?></h3>
                        <h4><?php
                        $depart = depart_emp($emp_id);
                        echo depart($depart);
                        ?></h4>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Employees</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Add Employees</a></li>
                        </ol>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Edit Advance/Loan Request</h4>
                            </div>
                            <div class="card-body">
                                <!-- Display success message only once -->
                               <?php if ($this->session->flashdata('flash_success')): ?>
                                <div class="alert alert-success"><?= $this->session->flashdata('flash_success') ?></div>
                               <?php unset($_SESSION['flash_success']); ?>
                                <?php endif; ?>
                                <?= validation_errors('<div class="alert alert-danger">', '</div>'); ?>

                                <form method="post" action="<?= base_url('Admin/update_advance_loan') ?>">
                                    <input type="hidden" name="id" value="<?= $advance->id ?>">
                                    <input type="hidden" name="emp_id" value="<?= $emp_id ?>">

                                    <div class="form-group">
                                        <label>Amount</label>
                                        <input type="number" name="amount" class="form-control"
                                            value="<?= (int) $advance->amount ?>" required min="1">
                                    </div>

                                    <div class="form-group">
                                        <label>Category</label>
                                        <select name="category" class="form-control" required>
                                            <option value="">Select Category</option>
                                            <option value="1" <?= $advance->category == 1 ? 'selected' : '' ?>>Advance
                                            </option>
                                            <option value="2" <?= $advance->category == 2 ? 'selected' : '' ?>>Loan
                                            </option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Date</label>
                                        <input type="date" name="created_at" class="form-control"
                                            value="<?= date('Y-m-d', strtotime($advance->created_at)) ?>" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Comments</label>
                                        <textarea name="comments"
                                            class="form-control"><?= $advance->comments ?></textarea>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <a href="<?= base_url('Admin/advance_loan/' . $emp_id) ?>"
                                        class="btn btn-secondary">Back</a>
                                </form>



                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="footer">
            <div class="copyright">
                <p>Copyright © Designed &amp; Developed by 2020</p>
            </div>
        </div>

    </div>
 <?php $this->load->view('footer'); ?>
</body>

<script>
    $(document).ready(function () {
        $('input[name="created_at"]').pickadate({
            format: 'yyyy-mm-dd',
            selectMonths: true,
            selectYears: true
        });
    });
</script>

</html>