<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Rizwan </title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo base_url(); ?>assets/images/favicon.png">
    <link rel="stylesheet"
        href="<?php echo base_url(); ?>assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/style.css">
    <!-- Pick date -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/pickadate/themes/default.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/pickadate/themes/default.date.css">
    <link href="<?php echo base_url(); ?>assets/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <!-- Custom Stylesheet -->
</head>

<body>
    <div id="preloader">
        <div class="sk-three-bounce">
            <div class="sk-child sk-bounce1"></div>
            <div class="sk-child sk-bounce2"></div>
            <div class="sk-child sk-bounce3"></div>
        </div>
    </div>
    <div id="main-wrapper">
        <?php $this->load->view('header'); ?>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        
                        <div class="sorting_1">
                            <img class="mr-3 rounded" alt="image" width="120"  src="<?php echo base_url('assets/images/profile/' . images($this->uri->segment(3))); ?>">
                        </div>
                        <h3><?php echo fullname($this->uri->segment(3)); ?></h3>
                        <h4><?php 
                        $depart =  depart_emp($this->uri->segment(3));
                        echo depart($depart);
                        ?></h4>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Employees</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">Add Employees</a></li>
                        </ol>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Employee Advance/Loan Request</h4>
                            </div>
                            <div class="card-body">
                                <!-- Display success message only once -->
                                <?php if (isset($flash_success)): ?>
                                    <div class="alert alert-success"><?= $flash_success ?></div>
                                <?php endif; ?>

                                <!-- Display validation errors if there are any -->
                                <?= validation_errors('<div class="alert alert-danger">', '</div>'); ?>

                                <!-- Form for submitting advance/loan -->
                                <form method="post" action="<?= base_url('Admin/save_advance_loan') ?>">
                                    <input type="hidden" name="emp_id" value="<?= $emp_id ?>">

                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label for="amount">Amount</label>
                                            <input type="number" name="amount" class="form-control" required min="1"
                                                placeholder="Enter amount">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="category">Category</label>
                                            <select name="category" class="form-control" required>
                                                <option value="">Select Category</option>
                                                <option value="1">Advance</option>
                                                <option value="2">Loan</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <!-- Label for the "Comments" field -->
                                            <label for="comments">Comments</label>
                                            <!-- Textarea for entering comments, 'name="comments"' binds it to the 'comments' field in the form -->
                                            <!-- 'required' makes this field mandatory, remove if optional -->
                                            <textarea name="comments" class="form-control" rows="4" placeholder="Enter any comments here..."></textarea>
                                        </div>

                                    </div>

                                    <button type="submit" class="btn btn-primary">Submit Advance</button>
                                </form>

                                <hr class="my-4">

                                <h5>Advance/Loan History</h5>
                                <?php if (!empty($advances)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped table-hover">
                                            <thead class="thead-dark">
                                                <tr>
                                                    <th>#</th>
                                                    <th>Category</th>
                                                    <th>Amount</th>
                                                    <th>Due Amount</th>
                                                    <th>Status</th>
                                                    <th>Date</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            
                                            <tbody>
                                                <?php foreach ($advances as $index => $advance): ?>
                                                    <tr>
                                                        <td><?= $index + 1 ?></td>
                                                        <td>
                                                            <?= $advance->category == '1' ? '<span class="badge badge-primary">Advance</span>' : '<span class="badge badge-info">Loan</span>'; ?>
                                                        </td>
                                                        <td>Rs. <?= number_format($advance->amount, 2) ?></td>
                                                        <td>Rs. <?= number_format($advance->due_balance, 2) ?></td> <!-- DUE BALANCE -->
                                                        <td>
                                                            <?= $advance->status == '0' ? '<span class="badge badge-danger">Due</span>' : '<span class="badge badge-success">Paid</span>'; ?>
                                                        </td>
                                                        <td><?= date('d-m-Y H:i', strtotime($advance->created_at)) ?></td>
                                                        <td>
                                                            <?php if ($advance->category == 1): ?>
                                                                    <a href="<?= base_url('Admin/mark_advance_paid/' . $advance->id) ?>" 
                                                                        class="btn btn-sm btn-primary"
                                                                        onclick="return confirm('Are you sure you want to mark this as Paid?');">
                                                                        Paid
                                                                        </a>
                                                                <?php else: ?>
                                                                    <a href="<?= base_url('Admin/pay_advance_loan/' . $advance->id) ?>" class="btn btn-sm btn-success">Payment</a>
                                                                <?php endif; ?>
                                                                <a href="<?= base_url('Admin/edit_advance_loan/' . $advance->id) ?>" class="btn btn-sm btn-warning">Edit</a>

                                                            <a href="<?= base_url('Admin/delete_advance_loan/' . $advance->id) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this record?');">Delete</a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>

                                        </table>
                                    </div>
                                <?php else: ?>
                                    <p>No advance records found for this employee.</p>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="footer">
            <div class="copyright">
                <p>Copyright © Designed &amp; Developed by 2020</p>
            </div>
        </div>

    </div>

    <?php $this->load->view('footer'); ?>

</body>

<!-- Mirrored from edumin.dexignlab.com/xhtml/add-departments.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 17 Nov 2020 13:56:15 GMT -->

</html>