<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Attendance System</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: url('<?= base_url("assets/bg.jpg") ?>') no-repeat center center fixed;
      background-size: cover;
      font-family: 'Segoe UI', sans-serif;
      color: #fff;
      min-height: 100vh;
    }

    .overlay {
      background-color: rgba(0, 0, 0, 0.65);
      min-height: 100vh;
      padding: 4rem 1rem;
    }

    .rfid-input {
      background-color: #f0f0f0;
      color: #333;
      border: 2px solid #ccc;
      padding: 0.7rem 1rem;
      font-size: 1.2rem;
      border-radius: 8px;
      width: 400px;
      max-width: 100%;
    }

    .logo {
      width: 180px;
    }

    .attendance-card {
      display: none;
      background-color: #ffffffcc;
      color: #333;
      padding: 1.5rem;
      border-radius: 1rem;
      max-width: 400px;
      margin: 1rem auto;
      box-shadow: 0 0 20px rgba(0,0,0,0.4);
    }

    .toast-container {
      position: fixed;
      top: 1rem;
      right: 1rem;
      z-index: 1055;
    }

    #loaderOverlay {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.6);
      display: none !important; /* Initially hidden */
      z-index: 2000;
      justify-content: center;
      align-items: center;
    }
  </style>
</head>
<body>
  <div class="overlay d-flex flex-column align-items-center justify-content-start text-center">
    <img src="<?= base_url('assets/logo.png') ?>" class="logo mb-4" alt="Logo">

    <!-- Loader Overlay -->
    <div id="loaderOverlay" class="d-flex">
      <div class="spinner-border text-light" role="status" style="width: 3rem; height: 3rem;">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>

    <!-- Form and Result Section -->
    <form id="tapin_form" class="mb-3">
      <input type="text" name="rfid_dec" id="rfid_dec" maxlength="10" class="rfid-input" placeholder="Scan your card" autocomplete="off" autofocus>
    </form>

    <div id="attendance_result" class="attendance-card"></div>
  </div>

  <div class="toast-container" id="toast-container"></div>

  <!-- jQuery and Bootstrap JS -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // Function to show toast messages
    function showToast(message, bg = 'bg-success') {
      const toastHTML = `
        <div class="toast align-items-center text-white ${bg} border-0 mb-2" role="alert" aria-live="assertive" aria-atomic="true">
          <div class="d-flex">
            <div class="toast-body">${message}</div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
          </div>
        </div>
      `;
      $('#toast-container').append(toastHTML);
      const toastEl = new bootstrap.Toast($('#toast-container .toast').last()[0]);
      toastEl.show();
    }

    $(document).ready(function() {
      // Hide the loader when the page is loaded
      $('#loaderOverlay').fadeOut();
      // Form submission handler
      $('#tapin_form').on('submit', function (e) {
        e.preventDefault();
        let rfid = $('#rfid_dec').val().trim();
        if (rfid.length !== 8) {
          showToast("Invalid RFID code", "bg-danger");
          return;
        }

        // Show loader before sending the request
        $('#loaderOverlay').fadeIn(); // Show loader
        $('#attendance_result').hide().html(''); // Clear the result display

        $.ajax({
            url: '<?= base_url("Admin/staff_atten") ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            beforeSend: function () {
              // Optional: Add logging here for debugging
              console.log("Before sending request: Loader should be visible now.");
            },
            success: function (response) {
                // Display the response when AJAX is successful
                $('#attendance_result').html(response.html).fadeIn();
                setTimeout(() => {
                    $('#attendance_result').fadeOut();
                }, 4000);
            },
            error: function () {
                // Display an error toast if the request fails
                showToast("Something went wrong. Please try again.", "bg-danger");
            },
            complete: function () {
                // Hide the loader once the AJAX request completes
                $('#loaderOverlay').fadeOut(); // Hide the loader
                $('#rfid_dec').val('').focus(); // Focus on the input field for next entry
            }
        });
      });
    });
  </script>
</body>
</html>
