<?php
class Sales_Orders extends CI_Model {


	 public function get_party()
		{
			$sql = $this->db->get('parties');
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

			public function reporting_data($start,$end){
			$this->db->select('sales_order.id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name');  
		  	 $this->db->from('sales_order');
				 $this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');

				 
			 	 $this->db->where('sales_order.so_date >=',$start);
			   $this->db->where('sales_order.so_date <=',$end);
			   //$this->db->where('sales_order.product_id !=','');
			   $this->db->order_by('sales_order.id','DESC');
			   $sql = $this->db->get();

				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
				}




		

		public function get_all_pro_fg()
	{
		$this->db->select('boms.main_product');  
		  
		$this->db->from('boms');
		//$this->db->where('id',$id);
		$this->db->group_by('boms.main_product');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	

		public function get_fg()
	{
		$this->db->select('products.id,products.name');  
		  
		$this->db->from('products');
		$this->db->where('product_type',5);
		//$this->db->group_by('products.main_product');
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}
	
	public function get_party_code($id)
	{
		$this->db->select('parties.party_code');  
		  
		$this->db->from('parties');
		$this->db->where('p_id',$id);
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}
	
	
	public function get_ref_party()
	{
		$this->db->select('fg_rates.ref_code');  
		  
		$this->db->from('fg_rates');
		$this->db->where('status',1);
		$this->db->group_by('ref_code');
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}
	
	public function fg_product_code($id)
	{
		$this->db->select('products.pro_code');  
		  
		$this->db->from('products');
		$this->db->where('id',$id);
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	

	 public function get_all_po()
	{
		/*$sql = $this->db->get_where('boms', array('id'=>$id));
		*/

		$this->db->select('sales_order.id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		$this->db->where('sales_order.status',0);
		
        //$this->db->where('sales_order.so_date >=','2023-01-01');
		$this->db->order_by("sales_order.id","desc");

		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

	}
	
	public function check_dc_status($so_id)
{
	// print_r($so_id);
	// die;
    $this->db->select('bill_created');
    $this->db->from('dc_record');
    $this->db->where('so_id', $so_id);
    $sql = $this->db->get();

    if ($sql->num_rows() > 0) {
        foreach ($sql->result() as $row) {
            if ($row->bill_created != 1) {
                return false; // If any entry has bill_created status as 0, return false
            }
        }
        return true; // All entries have bill_created status as 1
    }

    return false; // No entries found for the given so_id
}



	public function get_all_createbills()
	{
		$this->db->select('sales_order.id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name');  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		//$this->db->where('sales_order.status',0);
		$this->db->where('sales_order.bill_created',0);
		$this->db->where('sales_order.so_date >=','2024-12-01');
		$this->db->order_by("sales_order.id","desc");
		$this->db->group_by('sales_order.so_no');
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	
	public function get_all_tax_bills()
	{
		/*$sql = $this->db->get_where('boms', array('id'=>$id));
		*/
		$this->db->select('sales_order.id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name');  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		//$this->db->where('sales_order.status',0);
		$this->db->where('sales_order.bill_created',1);
        //$this->db->where('sales_order.so_date >=','2023-01-01');
		$this->db->order_by("sales_order.id","desc");
		$this->db->group_by('sales_order.so_no');
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	public function fulter_view_sales_tax_bill($id){
		$this->db->select('Sum(total_value) as total_value,bill_no,so_id,Sum(qty) as qty');  
		$this->db->from('complete_bills');
		$this->db->where('complete_bills.so_id',$id);
		
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	public function get_all_bills(){
		$this->db->select('so_id,Sum(total_value)as total_value,bill_no,status');  
		$this->db->from('complete_bills');
		$this->db->where('complete_bills.status',0);
		$this->db->group_by('so_id');
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	public function view_all_dc($id){
		$this->db->select('*');  
		$this->db->from('dc_record');
		$this->db->where('dc_record.so_id',$id);
		$this->db->where('dc_record.bill_created',0);
		$this->db->order_by("dc_record.id","desc");
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	
	public function view_sales_tax_bill($id){
		$this->db->select('*');  
		$this->db->from('complete_bills');
		$this->db->where('complete_bills.so_id',$id);
		
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	public function get_bill_data_modal($id){
		$this->db->select('sum(total_value)as total_value,so_id');  
		$this->db->from('complete_bills');
		$this->db->where('complete_bills.so_id',$id);
		$this->db->group_by('so_id');
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}
	
	public function get_banks(){
		$this->db->select('*');  
		$this->db->from('banks');
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	 public function get_all_po_dashboard($today_date)
	{
		/*$sql = $this->db->get_where('boms', array('id'=>$id));
		*/

		$this->db->select('sales_order.id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name,dc_record.insert_date');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		$this->db->join('dc_record', 'sales_order.id = dc_record.so_id', 'left');
		$this->db->where('sales_order.status',0);
		$this->db->where('dc_record.insert_date',$today_date);
		
		$this->db->order_by("sales_order.id","desc");

		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

	}
	
	
	 public function add_dc_company($save_po) {
          $result = $this->db->insert('company_dc',$save_po);
          if($result){return true;}else{return false;} 
		  
    }

	public function add_bill_receviepayment($save_po) {
		$result = $this->db->insert('bill_payment',$save_po);
		if($result){return true;}else{return false;} 
		
  }

	
    
    
    public function dc_company_data()
		{
			$this->db->select('* ');  
		  $this->db->from('company_dc');
			$this->db->group_by("company_dc.dc_challan");
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

		
		public function get_dcs_company_dc($id)
		{
			$this->db->select('* ');  
		  $this->db->from('company_dc');
			//$this->db->group_by("company_dc.dc_challan");
		  $this->db->where('dc_challan',$id);
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}


	
		public function delete_data_sales_order($id)
			{
				

				$this->db->select('*');
			    $this->db->from('sales_order');
			    $this->db->join('sales_order_products','sales_order.id = sales_order_products.so_id');
			    $this->db->where('sales_order.id',$id);
			    $this->db->delete('sales_order', 'sales_order_products');


				return true;
			}


			
			public function check_sono($so_no)
			{
				$this->db->select('so_no');
			    $this->db->from('sales_order');
			    $this->db->where('sales_order.so_no',$so_no);
				$sql = $this->db->get();
				if($sql->num_rows() >0)
				{return $sql->result_array();
				}else
				{return false;}
			}
			

			public function get_edit_sales_order($id)
			{
				

				$this->db->select('*');
			    $this->db->from('sales_order');
			    $this->db->join('sales_order_products','sales_order.id = sales_order_products.so_id');
			    $this->db->where('sales_order.id',$id);
			    $sql = $this->db->get();

			    if($sql->num_rows() >0)
					{return $sql->result_array();
					}else
					{return false;}
			    //$this->db->delete('sales_order', 'sales_order_products');


				return true;
			}
			
			
			public function all_delivery_challan()
		{
		/*$sql = $this->db->get_where('boms', array('id'=>$id));
		*/

		$this->db->select('sales_order.id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
	
        $this->db->order_by('sales_order.so_date','DESC');
		
		$sql = $this->db->get();
   /// print_r($this->db->last_query($sql));   die;
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

	}
			
			
			
			
			
			public function delete_data_sales_order_data($id)
				{
					$sql = $this->db->delete('sales_order', array('id'=>$id));
					
					return true;
				}
				
				
				public function delete_dc($id)
				{
					$sql = $this->db->delete('dc_record', array('id'=>$id));

					$sql = $this->db->delete('stock_out', array('dc_id'=>$id));
					
					return true;
				}
				
				

				public function delete_data_sales_order_pro($id)
				{
					$sql = $this->db->delete('sales_order_products', array('so_id'=>$id));
					
					return true;
				}

				
	
	 public function add_sales_order($save_po) {
          $result = $this->db->insert('sales_order',$save_po);
          if($result){return $this->db->insert_id();}else{return false;} 
		  
    }


    public function update_order_products_status($id) {


        $result = $this->db->where('id',$id);
		$result = $this->db->update('sales_order',array('status' => 1));
		if($result){return true;}else{return false;}
	}
	
	public function update_payment_status($id) {
        $result = $this->db->where('so_id',$id);
		$result = $this->db->update('complete_bills',array('status' => 1));
		if($result){return true;}else{return false;}
	}
	
	public function update_so_status($id) {


        $result = $this->db->where('id',$id);
		$result = $this->db->update('sales_order',array('bill_created' => 1));
		if($result){return true;}else{return false;}
	}

	

	public function bill_reports() {

		$result = $this->db->update('sales_order',array('bill_created' => 2));
		if($result){return true;}else{return false;}
	}

	
	public function sales_tax_update_so_status($id) {


        $result = $this->db->where('id',$id);
		$result = $this->db->update('sales_order',array('bill_created' => 2));
		if($result){return true;}else{return false;}
	}

	public function update_dc_status($id) {
        $result = $this->db->where('id',$id);
		$result = $this->db->update('dc_record',array('bill_created' => 1));
		if($result){return true;}else{return false;}
	}

    
    public function update_so($id,$save_po) {
	$result = $this->db->where('id',$id);
	$result = $this->db->update('sales_order',$save_po);
	if($result){return true;}else{return false;}

	}

	 public function update_dc_invoice_data($id,$save_po) {
	  $result = $this->db->where('id',$id);
	  $result = $this->db->update('dc_record',$save_po);
	if($result){return true;}else{return false;}

	}

	



	public function update_so_products($id,$save_po1) {
	$result = $this->db->where('so_id',$id);
	$result = $this->db->update('sales_order_products',$save_po1);
	if($result){return true;}else{return false;}

	}

    public function add_sales_order_products($save_po1) {
          $result = $this->db->insert('sales_order_products',$save_po1);
          if($result){return true;}else{return false;} 
		  
    }
	

	public function filter_bill_report($id, $bill_no,$date, $enddate,$parties) {
		$this->db->select('sales_order.id, sales_order.so_no, sales_order.party_id, sales_order.pay_term');  
		$this->db->from('sales_order');
		$this->db->join('complete_bills', 'sales_order.id = complete_bills.so_id', 'left');
		//$this->db->where("sales_order.bill_created", 2);
		$this->db->where("(sales_order.bill_created = 2 OR sales_order.bill_created = 1)");

		$this->db->group_by("complete_bills.so_id", 'DESC');

		// Add filter conditions based on the provided parameters
		if (!empty($id)) {
		$this->db->where("complete_bills.so_id", $id);
		}

		if (!empty($bill_no)) {
			$this->db->where("complete_bills.bill_no", $bill_no);
			}

		if (!empty($date)) {
			
		$this->db->where("complete_bills.insert_date >= ", $date);
		}

		if (!empty($enddate)) {
		$this->db->where("complete_bills.insert_date <= ", $enddate);
		}

		if(!empty($parties)){
			$this->db->where("sales_order.party_id ",$parties);
		}

		// Execute the query
		$sql = $this->db->get();
		// print_r($this->db->last_query($sql));   die;
	
		if ($sql->num_rows() > 0) {
			return $sql->result_array();
		} else {
			return false;
		}
	}

	
	public function filter_bill_payment_report($id,$party)
{
	// Add filter conditions based on the provided parameters
	if (!empty($party)) {
		$this->db->select('(SELECT SUM(amount) FROM bill_payment WHERE bill_payment.so_id = complete_bills.so_id) AS amount', FALSE);
		$this->db->select('complete_bills.so_id');
		$this->db->select('(SELECT SUM(total_value) FROM complete_bills WHERE complete_bills.so_id = sales_order.id) AS total_value', FALSE);
		$this->db->from('complete_bills');
		$this->db->join('sales_order', 'complete_bills.so_id = sales_order.id', 'left');
		$this->db->where('sales_order.party_id', $party);
		$this->db->group_by('complete_bills.so_id');
		


	} elseif (!empty($id)) {
		$this->db->select('(SELECT SUM(amount) FROM bill_payment WHERE so_id = "'.$id.'") AS amount', FALSE);
		$this->db->select('complete_bills.so_id');
		$this->db->select('(SELECT SUM(total_value) FROM complete_bills WHERE so_id = "'.$id.'" ) AS total_value', FALSE);
		$this->db->from('complete_bills');
		$this->db->where('complete_bills.so_id', $id);
		$this->db->group_by('complete_bills.so_id');
	}


    // Execute the query
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return false;
    }
}

	

public function filter_banking($id)
{
	$this->db->select('bank,so_id,mode,amount,created_at');  
	$this->db->from('bill_payment');
	//$this->db->join('complete_bills', 'sales_order.id = complete_bills.so_id', 'left');
	//$this->db->where("bill_payment.bank",$id);
	//$this->db->group_by("bill_payment.so_id", 'DESC');

	// Add filter conditions based on the provided parameters
	if (!empty($id)) {
	$this->db->where("bill_payment.bank", $id);
	}

    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return false;
    }
}
	

    public function get_all_so_products($id)
		{
			$sql = $this->db->get_where('sales_order_products', array('so_id'=>$id));
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

		public function so_bill_reports()
		{
			$sql = $this->db->get_where('sales_order', array('bill_created'=>2));
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}
		
		public function bill_bill_reports()
		{
		$this->db->select('*');  
		$this->db->from('complete_bills');
		//$this->db->where("status",1);
		$this->db->group_by("bill_no");
		$sql = $this->db->get();
		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function bill_no()
		{
			$this->db->select('bill_no');  
			$this->db->from('complete_bills');
			$this->db->group_by("complete_bills.bill_no", 'DESC');
			$sql = $this->db->get();
			if ($sql->num_rows() > 0) {
			return $sql->result_array();
			} else {
			return false;
			}
		}

		

		
		public function update_dc_invoice($id)
		{
			$sql = $this->db->get_where('dc_record', array('id'=>$id));
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

		public function get_all_dc()
		{
			$sql = $this->db->get('dc_record');
			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

		

		

		public function get_so_dcs($id)
		{
			//$sql = $this->db->get_where('dc_record', array('so_id'=>$id));

		$this->db->select('*');  
		  
		$this->db->from('dc_record');
	
		$this->db->where("so_id",$id);

		$this->db->group_by("dc_no");

		//
		$sql = $this->db->get();


			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}

		public function get_all_confirm_so()
		{
			//$sql = $this->db->get_where('sales_order', array('status'=>1));
			$this->db->select('sales_order.id as sales_order_id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name,sales_order_products.so_id,sales_order_products.product_id,sales_order_products.bom_status');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'left');
		//$this->db->where('sales_order.bom_status',1);
		$this->db->group_by("sales_order_products.so_id");

		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		


		public function get_all_confirm_so_active_admin()
		{
			//$sql = $this->db->get_where('sales_order', array('status'=>1));
			$this->db->select('sales_order.id as sales_order_id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name,sales_order_products.so_id,sales_order_products.product_id,sales_order_products.bom_status');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'left');
		$this->db->where('sales_order_products.bom_status',1);
		//$this->db->where('sales_order_products.finish_requisition',0);
		$this->db->where('sales_order.so_date >=','2023-04-17');
		$this->db->group_by("sales_order_products.so_id");

		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_all_confirm_so_active()
		{
			//$sql = $this->db->get_where('sales_order', array('status'=>1));
			$this->db->select('sales_order.id as sales_order_id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name,sales_order_products.so_id,sales_order_products.product_id,sales_order_products.bom_status,sales_order_products.finish_requisition');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'left');
		$this->db->where('sales_order_products.bom_status',1);
		$this->db->where('sales_order_products.finish_requisition !=',2);
		$this->db->group_by("sales_order_products.so_id");

		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function update_status_bom($so_id) {


        $result = $this->db->where('so_id',$so_id);
		$result = $this->db->update('sales_order_products',array('bom_status' => 1));
		if($result){return true;}else{return false;}
	}


		public function view_so_products($id)
		{
			//$sql = $this->db->get_where('sales_order', array('status'=>1));
			$this->db->select('sales_order.id as sales_order_id,sales_order.party_id,sales_order.so_no,sales_order.so_date,sales_order.instruction,sales_order.pay_term,sales_order.status,parties.p_id,parties.party_code as party_code,parties.name as party_name,sales_order_products.so_id,sales_order_products.product_id,sales_order_products.id as sales_pro_id');  
		  
		$this->db->from('sales_order');
		$this->db->join('parties', 'sales_order.party_id = parties.p_id', 'left');
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'left');
		//$this->db->where('sales_order.bom_status',1);
		$this->db->where("sales_order.id",$id);

		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		

		public function challan_qty_delivery($id)
		{
			$this->db->select('SUM(dc_record.qty) as qty ');  
		  $this->db->from('dc_record');
		
			$this->db->where("dc_record.dc_no",$id);
			//$this->db->group_by('');
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_destroy_bom($id)
		{
		  $this->db->select('boms.main_product,boms.product_id,boms.child_product,sales_order_products.product_id as sales_products,sales_order_products.quantity');  
		  
		$this->db->from('boms');
		$this->db->join('sales_order_products', 'boms.main_product = sales_order_products.product_id', 'left');
		$this->db->where("sales_order_products.id",$id);
		$this->db->group_by("boms.product_id");
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}



		public function get_destroy_bom_po($id)
		{
		  $this->db->select('boms.main_product,boms.product_id,boms.child_product,sales_order_products.product_id as sales_products,sales_order_products.quantity');  
		  
		$this->db->from('boms');
		$this->db->join('sales_order_products', 'boms.main_product = sales_order_products.product_id', 'left');
		$this->db->where("sales_order_products.so_id",$id);
		$this->db->group_by("boms.product_id");
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_child_productdata($id)
		{
		  $this->db->select('boms.product_id ');  
		  
		$this->db->from('boms');
		//$this->db->join('sales_order_products', 'boms.main_product = sales_order_products.product_id', 'left');
		$this->db->where("boms.main_product",$id);
		//$this->db->group_by("boms.product_id");
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_materials_boms($id,$child_data)
		{
	    $this->db->select('boms_materials.material_id,boms_materials.weight,boms_materials.unit,boms_materials.product_id');  
		  
		$this->db->from('materials');
		$this->db->join('boms_materials', 'materials.id = boms_materials.material_id', 'left');
		$this->db->where("materials.type !=",2);
		$this->db->where("boms_materials.main_product",$id);
		$this->db->where_in("boms_materials.product_id",$child_data);
		//$this->db->group_by("boms_materials.material_id");
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_materials_boms1($id)
		{
	    $this->db->select('boms_materials.material_id,sum(boms_materials.weight) as weight,boms_materials.unit,boms_materials.product_id');  
		  
		$this->db->from('materials');
		$this->db->join('boms_materials', 'materials.id = boms_materials.material_id', 'left');
		$this->db->where("materials.type !=",2);
		$this->db->where("boms_materials.main_product",$id);
		$this->db->group_by("boms_materials.material_id");
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_materials_packing_boms($id)
		{
	    $this->db->select('boms_materials.material_id,sum(boms_materials.weight) as weight,boms_materials.unit');  
		  
		$this->db->from('materials');
		$this->db->join('boms_materials', 'materials.id = boms_materials.material_id', 'left');
		$this->db->where("materials.type",2);
		$this->db->where("boms_materials.main_product",$id);
		$this->db->group_by("boms_materials.material_id");
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		/*public function get_molded_boms($id)
		{
	    $this->db->select('boms.product_id');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.product_id', 'left');
		$this->db->where("products.product_type",1);
		$this->db->where("boms.main_product",$id);
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}
*/

		public function get_moldedchild_boms($id)
		{
	    $this->db->select('boms.product_id,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.product_id', 'left');
		$this->db->where("products.product_type",1);
		$this->db->where("boms.main_product",$id);


		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		
		public function get_boms_mat($id)
		{
	    $this->db->select('boms_materials.product_id,boms_materials.weight,boms_materials.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms_materials', 'products.id = boms_materials.product_id', 'left');
		$this->db->where("products.product_type",1);
		$this->db->where("boms_materials.main_product",$id);
		$this->db->group_by("boms_materials.product_id");


		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}
    	
    	public function get_printed_boms($id)
		{
	    $this->db->select('boms.product_id,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.product_id', 'left');
		$this->db->where("products.product_type",2);
		$this->db->where("boms.main_product",$id);
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_printedchild_boms($id)
		{
	    $this->db->select('boms.child_product,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.child_product', 'left');
		$this->db->where("products.product_type",2);
		$this->db->where("boms.main_product",$id);
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		public function get_assembled_boms($id)
		{
	    $this->db->select('boms.product_id,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.product_id', 'left');
		$this->db->where("products.product_type",3);
		$this->db->where("boms.main_product",$id);
		$this->db->group_by("boms.product_id");
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_assembled_child_boms($id)
		{
	   
		$this->db->select('boms.child_product,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.child_product', 'left');
		$this->db->where("products.product_type",3);
		$this->db->where("boms.main_product",$id);


		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

		/*public function get_assembled_boms($id)
		{
	    $this->db->select('boms.child_product,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.child_product', 'left');
		$this->db->where("products.product_type",3);
		$this->db->where("boms.main_product",$id);
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}*/



		/*public function get_sealed_boms($id)
		{
	    $this->db->select('boms.product_id,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.product_id', 'left');
		$this->db->where("products.product_type",4);
		$this->db->where("boms.main_product",$id);
		$this->db->group_by("boms.product_id");
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}*/

		public function get_sealed_boms($id)
		{
	    $this->db->select('boms.product_id,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.product_id', 'left');
		$this->db->where("products.product_type",4);
		$this->db->where("boms.main_product",$id);
		$this->db->group_by("boms.product_id");
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}


		public function get_sealed_child_boms($id)
		{
	    $this->db->select('boms.child_product,boms.weight,boms.unit');  
		  
		$this->db->from('products');
		$this->db->join('boms', 'products.id = boms.child_product', 'left');
		$this->db->where("products.product_type",4);
		$this->db->where("boms.main_product",$id);
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

    public function fg_product_rates($param)
	{
		$this->db->select('fg_rates.rates');  
		  
		$this->db->from('fg_rates');
		$this->db->where('ref_code',$param);
		$this->db->where('status',1);
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}
		
		
		public function so_po_boms_data($param)
		{
		  $this->db->select('so_po_boms.so_id,so_po_boms.quantity,so_po_boms.main_product,puchase_order_details.material_id,puchase_order_details.child_product,puchase_order_details.unit,puchase_order_details.total');  
		  
		$this->db->from('so_po_boms');
		$this->db->join('puchase_order_details', 'so_po_boms.id = puchase_order_details.so_po_id', 'left');
		$this->db->where("so_po_boms.so_id",$param);
		$this->db->where("puchase_order_details.child_product",0);
		//$this->db->group_by("boms.product_id");
		//
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
		}

    

    public function get_invoice_data($id)
	{
		

		$this->db->select('sales_order.party_id,sales_order.id,sales_order.so_no,sales_order.so_date,sales_order_products.product_id,sales_order_products.quantity,sales_order_products.unit_rate,sales_order_products.product_id,sales_order_products.so_id,sales_order_products.created,sales_order_products.amount,sales_order_products.delv_date,sales_order_products.ref_code,sales_order_products.gst,sales_order_products.total_qty');  
		  
		$this->db->from('sales_order');
		
		$this->db->join('sales_order_products', 'sales_order.id = sales_order_products.so_id', 'inner');
		$this->db->where("sales_order_products.so_id",$id);	
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

	}


	

	

	public function get_invoice_dc($id)
	{
		$this->db->select('dc_record.id,dc_record.so_id,dc_record.dc_no,dc_record.qty,dc_record.created');  
		  
		$this->db->from('dc_record');
		$this->db->where('so_id',$id);
		$this->db->order_by('dc_record.id','DESC');
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}



	
		public function invoice_print_dc($id)
	{
		$this->db->select('dc_record.id,dc_record.so_id,dc_record.dc_no,dc_record.qty,dc_record.batch,dc_record.created');  
		  
		$this->db->from('dc_record');
		$this->db->where('id',$id);
		
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}


	 public function get_dc_qty($id)
		{
			$this->db->select('SUM(dc_record.qty) AS qty,dc_record.qc_status');    
			$this->db->from('dc_record');
			$this->db->where("dc_record.so_id",$id); 
			$this->db->where("dc_record.qc_status !=",3); 
			$sql = $this->db->get();

			if($sql->num_rows() >0)
			{return $sql->result_array();
			}else
			{return false;}
		}



		public function add_dc($post) {
          $result = $this->db->insert('dc_record',$post);
          if($result){return $this->db->insert_id();}else{return false;} 
		 }


		 

		 public function get_code_dc(){

		$this->db->select('dc_record.dc_no');  
		  
		$this->db->from('dc_record');
		//$this->db->where('type',1);
		$this->db->order_by('dc_record.id','DESC');
		
		$this->db->limit(1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}



	 public function get_code_dc_gst(){

		$this->db->select('dc_record.dc_no');  
		  
		$this->db->from('dc_record');
		$this->db->where('gst',0);
		$this->db->where('gst','');
		$this->db->order_by('dc_record.id','DESC');
		
		$this->db->limit(1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}


	
	public function get_fg_sets($product){

		$this->db->select('fg_sets.product_id');  
		  
		$this->db->from('fg_sets');
		$this->db->where('fg_id',$product);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	public function get_billno_bill(){

		$this->db->select('complete_bills.bill_no');  
		  
		$this->db->from('complete_bills');
		// $this->db->where('gst',0);
		// $this->db->where('gst','');
		$this->db->order_by('complete_bills.id','DESC');
		
		$this->db->limit(1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}
	}

	public function get_company(){
		$this->db->select('parties.p_id,parties.name');  
		  
		$this->db->from('parties');
		// $this->db->where('gst',0);
		// $this->db->where('gst','');
		//$this->db->order_by('parties.id','DESC');
		
		//$this->db->limit(1);
		$sql = $this->db->get();

		if($sql->num_rows() >0)
		{return $sql->result_array();
		}else
		{return false;}

	}


	public function add_bills($save_po) {
		$result = $this->db->insert('complete_bills',$save_po);
		if($result){return true;}else{return false;} 
		
  }
}