<?php
class Advance_loan_model extends CI_Model {

    public function insert($data) {
        return $this->db->insert('advance_loans', $data);
    }

    public function get_loans_by_employee($emp_id) {
        return $this->db->get_where('advance_loans', ['emp_id' => $emp_id])->result();
    }


   public function get_total_paid($parent_id)
{
    $row = $this->db->select_sum('amount')
                    ->where('parent_id', $parent_id)
                    ->get('advance_loans')
                    ->row();

    return isset($row->amount) ? $row->amount : 0;
}


    public function update_status($id, $status)
{
    return $this->db->where('id', $id)->update('advance_loans', ['status' => $status]);
}

public function get_advance_by_id($id)
{
    return $this->db->get_where('advance_loans', ['id' => $id])->row();
}


public function get_payment_by_id($id)
{
    return $this->db->get_where('advance_loans', ['id' => $id])->row();
}

public function update_payment($id, $data)
{
    return $this->db->where('id', $id)->update('advance_loans', $data);
}


}
?>