<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('check_login'))
{
    function check_login()
    {
    	$ci=& get_instance();
    	if($ci->session->userdata('id')){
    		return true;
    	}else{
    		redirect(base_url());
    	}
    }   
}


if ( ! function_exists('images'))
{
    function images($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->image;
    }   
}

if (!function_exists('check_multiple')) {
    function check_multiple($id)
    {
        $ci = &get_instance();
        $ci->load->database();
        $ci->db->select('so_id');
        $ci->db->from('dc_record');
        $ci->db->where('so_id', $id);
        $query = $ci->db->get();
       
        $numRows = $query->num_rows();
        
        if ($numRows > 1) {
            return 'multiple';
        } elseif ($numRows == 1) {
            return 'single';
        }

        return 'not created';
    }
}


if (!function_exists('get_so_from_dcrecord')) {
    function get_so_from_dcrecord($id)
    {
        $ci = &get_instance();
        $ci->load->database();
        $ci->db->select('so_id');
        $ci->db->from('dc_record');
        $ci->db->where('id', $id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->so_id;
        
    }
}


if (!function_exists('get_product_id')) {
    function get_product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }  
}

if (!function_exists('numberToWords')) {
    function numberToWords($number)
    {
    $ones = array(
        0 => 'Zero',
        1 => 'One',
        2 => 'Two',
        3 => 'Three',
        4 => 'Four',
        5 => 'Five',
        6 => 'Six',
        7 => 'Seven',
        8 => 'Eight',
        9 => 'Nine',
        10 => 'Ten',
        11 => 'Eleven',
        12 => 'Twelve',
        13 => 'Thirteen',
        14 => 'Fourteen',
        15 => 'Fifteen',
        16 => 'Sixteen',
        17 => 'Seventeen',
        18 => 'Eighteen',
        19 => 'Nineteen'
    );

    $tens = array(
        2 => 'Twenty',
        3 => 'Thirty',
        4 => 'Forty',
        5 => 'Fifty',
        6 => 'Sixty',
        7 => 'Seventy',
        8 => 'Eighty',
        9 => 'Ninety'
    );

    $words = '';

    if ($number < 20) {
        $words = $ones[$number];
    } elseif ($number < 100) {
        $words = $tens[floor($number / 10)];
        $remainder = $number % 10;

        if ($remainder > 0) {
            $words .= ' ' . $ones[$remainder];
        }
    }

    return $words;
    }
}

if (!function_exists('get_fg_rates')) {
    function get_fg_rates($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('product'=>$id,'status'=>1));
        if($query->num_rows()>0) return $query->first_row()->rates;
    }  
}

if (!function_exists('company_decription')) {
    function company_decription($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('company_description',array('fg_ref_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->description;
    }  
}




if (!function_exists('qty_dc_record')) {
    function qty_dc_record($id)
    {
        $ci = &get_instance();
        $ci->load->database();
        $ci->db->select('qty');
        $ci->db->from('dc_record');
        $ci->db->where('id', $id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
        
    }
}


if ( ! function_exists('ref_product_id'))
{
    function ref_product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('ref_code'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product;
    }   
}

if ( ! function_exists('fg_rates_product'))
{
    function fg_rates_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('product'=>$id , 'status'=>'1'));
        if($query->num_rows()>0) return $query->first_row()->rates;
    }   
}

if ( ! function_exists('fg_rates_product_desc'))
{
    function fg_rates_product_desc($id)
    {
       
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('product'=>$id , 'status'=>'1'));
        if($query->num_rows()>0) return $query->first_row()->ref_code;
    }   
}

if ( ! function_exists('fg_rates'))
{
    function fg_rates($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('ref_code'=>$id));
        if($query->num_rows()>0) return $query->first_row()->rates;
    }   
}


if ( ! function_exists('fg_rates_ref_code'))
{
    function fg_rates_ref_code($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->ref_code;
    }   
}   

if ( ! function_exists('get_production_semi_standrd'))
{
    function get_production_semi_standrd($job,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('semi_standard');
         $ci->db->from('production_plan');
      
          $ci->db->where('job',$job);
          $ci->db->where('so_id',$so_id);
           
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->semi_standard;
    }   


}

if ( ! function_exists('get_per_pcs_weight'))
{
    function get_per_pcs_weight($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->weight;
    }   
}

if ( ! function_exists('ref_code_fgrates_id'))
{
    function ref_code_fgrates_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_rates',array('ref_code'=>$id));
        if($query->num_rows()>0) return $query->first_row()->id;
    }   
}


if ( ! function_exists('get_emp_id'))
{
    function get_emp_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('tap_in_out',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->emp_id;
    }   
}


if ( ! function_exists('qc_machine_id'))
{
    function qc_machine_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->day_night;
    }   
}



 if ( ! function_exists('mahine_for_print'))
{
    function mahine_for_print($so_id,$product)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('machine');
         $ci->db->from('production_machine_remarks');
      
          $ci->db->where('so_id',$so_id);
          $ci->db->where('product_id',$product);
           
            $ci->db->where('status',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->machine;
    }   


}




if ( ! function_exists('get_all_spare'))
{
    function get_all_spare($so_id,$product_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('sum(spare) as all_spare');
         $ci->db->from('in_stock_log');
      
          $ci->db->where('so_id',$so_id);
          $ci->db->where('product_id',$product_id);
           
            $ci->db->where('pcs_status',1);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->all_spare;
    }   


}
     if ( ! function_exists('get_pc_weight'))
{
    function get_pc_weight($job,$machine)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date("Y-m-d");
         $ci->db->select('pcs_weight_range');
         $ci->db->from('randomly_check_qc');
      
          $ci->db->where('machine',$machine);
          $ci->db->where('job',$job);
           
        $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->pcs_weight_range;
    }  

}


if ( ! function_exists('get_qty_complete_bill'))
{
    function get_qty_complete_bill($so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $ci->db->select('sum(qty) as qtty');
        $ci->db->from('complete_bills');
        $ci->db->where('so_id',$so_id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qtty;
    }  

}


   if ( ! function_exists('get_ramdomlyemp'))
{
    function get_ramdomlyemp($job,$product)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date("Y-m-d");
         $ci->db->select('operator');
         $ci->db->from('randomly_check_qc');
      
          
          $ci->db->where('job',$job);
           $ci->db->where('product_name',$product);
       
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->operator;
    }   


}



    if ( ! function_exists('get_so_from_machine'))
{
    function get_so_from_machine($qc_product_id,$qc_machine_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date("Y-m-d");
         $ci->db->select('so_id');
         $ci->db->from('production_machine_remarks');
      
          $ci->db->where('machine',$qc_machine_id);
          $ci->db->where('product_id',$qc_product_id);
           
       // $ci->db->where('status',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   


}



   if ( ! function_exists('get_material_weight'))
{
    function get_material_weight($day_night,$seg_date,$job)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date("2022-10-01");
        $date = date("Y-m-d");
         $ci->db->select('sum(m_weight) as m_weight');
         $ci->db->from('in_stock_log');
      
      
        $ci->db->where('shift',$day_night);
        $ci->db->where('insert_date',$seg_date);
        $ci->db->where('job',$job);
        $query = $ci->db->get();
       // print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->m_weight;
    }   


}



 if ( ! function_exists('get_standard_weight'))
{
    function get_standard_weight($job)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date("Y-m-d");
         $ci->db->select('weight_standard');
         $ci->db->from('production_plan');
      
          $ci->db->where('job',$job);
          
        
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->weight_standard;
    }   


}


if ( ! function_exists('get_standard_qty'))
{
    function get_standard_qty($job)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date("Y-m-d");
         $ci->db->select('semi_standard');
         $ci->db->from('production_plan');
      
          $ci->db->where('job',$job);
          
        
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->semi_standard;
    }   


}



   if ( ! function_exists('get_complain_hours'))
{

 function get_complain_hours($job,$qc_machine_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date("Y-m-d");
         $ci->db->select('production_stoping_time');
         $ci->db->from('complain_hour_check_qc');
      
          $ci->db->where('job',$job);
          $ci->db->where('machine',$qc_machine_id);
         $ci->db->order_by('id','DESC');
        
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->production_stoping_time;
    }   


}



if ( ! function_exists('get_waste_weight'))
{
    function get_waste_weight($seg_date,$day_night,$job)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date("2022-10-01");
        //$date = date("Y-m-d");
         $ci->db->select('sum(w_weight)as w_weight');
         $ci->db->from('in_stock_log');
      
          //$ci->db->where('so_id',$get_so_from_machine);
          //$ci->db->where('product_id',$qc_product_id);
          $ci->db->where('insert_date',$seg_date);
        $ci->db->where('shift',$day_night);
         $ci->db->where('job', $job);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->w_weight;
    }   


}


if ( ! function_exists('product_match_job11'))
{
    function product_match_job11($product_id,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('job');
         $ci->db->from('production_plan');
         $ci->db->where('product_name',$product_id);
         $ci->db->where('so_id',$so_id);
         $query = $ci->db->get();
         if($query->num_rows()>0) return $query->first_row()->job;
    }   

}






if ( ! function_exists('get_so_machineid'))
{
    function get_so_machineid($so_id,$p_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('machine');
         $ci->db->from('production_machine_remarks');
        
          $ci->db->where('so_id',$so_id);
           $ci->db->where('product_id',$p_id);

        //$ci->db->where('emp_id',$system);
        $query = $ci->db->get();
        //print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->machine;
    }   


}


if ( ! function_exists('get_emp_date'))
{
    function get_emp_date($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('tap_in_out',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->date;
    }   
}

if ( ! function_exists('get_emp_time'))
{
    function get_emp_time($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->tap_in;
    }   
}

if ( ! function_exists('get_systemtaps'))
{
    function get_systemtaps($tapin,$system,$month1,$year1)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('count(tap_in) as total');
         $ci->db->from('tap_in_out');
         $ci->db->where('tap_in >',$tapin);
          $ci->db->where('emp_id',$system);
          $ci->db->where('MONTH(date)',$month1);
           $ci->db->where('YEAR(date)',$year1);

            //$ci->db->where('emp_id',$system);
        $query = $ci->db->get();
        //print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->total;
    }   


}


if ( ! function_exists('machine_get_qc_check'))
{
    function machine_get_qc_check($today_date)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('count(insert_date) as total');
         $ci->db->from('add_timing_qc');
         $ci->db->where('insert_date',$today_date);
         $query = $ci->db->get();
         if($query->num_rows()>0) return $query->first_row()->total;
    }   

}


if ( ! function_exists('machine_daily_ramdomly'))
{
    function machine_daily_ramdomly($today_date)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('count(insert_date) as total');
         $ci->db->from('randomly_check_qc');
         $ci->db->where('insert_date',$today_date);
         $query = $ci->db->get();
         if($query->num_rows()>0) return $query->first_row()->total;
    }   

}


if ( ! function_exists('machine_get_supervisor'))
{
    function machine_get_supervisor($today_date)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('count(insert_date) as total');
         $ci->db->from('supervisor_qc');
         $ci->db->where('insert_date',$today_date);
         $query = $ci->db->get();
         if($query->num_rows()>0) return $query->first_row()->total;
    }   

}

if ( ! function_exists('machine_get_complain_hour'))
{
    function machine_get_complain_hour($today_date)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('count(insert_date) as total');
         $ci->db->from('complain_hour_check_qc');
         $ci->db->where('insert_date',$today_date);
         $query = $ci->db->get();
         if($query->num_rows()>0) return $query->first_row()->total;
    }   

}


if ( ! function_exists('get_over_time'))
{
    function get_over_time($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->over_time;
    }   
}




if ( ! function_exists('check_condition'))
{
    function check_condition($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machine_daily_report',array('qc_machine_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qc_machine_id;
    }   
}



if ( ! function_exists('get_tap_out'))
{
    function get_tap_out($system,$mydate)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('count(date_out) as total');
         $ci->db->from('tap_in_out');
         $ci->db->where('date_out','0000-00-00');
          $ci->db->where('emp_id',$system);
           $ci->db->where('date >=',$mydate);
           
            //$ci->db->where('emp_id',$system);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   


}



if ( ! function_exists('check_status_machine'))
{
    function check_status_machine($id,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('status');
         $ci->db->from('production_machine_remarks');
     
 
          $ci->db->where('product_id',$id);
           $ci->db->where('so_id',$so_id);
            //$ci->db->where('emp_id',$system);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->status;
    }  


}



if ( ! function_exists('check_production_status'))
{
    function check_production_status($so_id,$product)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('id');
         $ci->db->from('production_plan');
      
          $ci->db->where('so_id',$so_id);
          $ci->db->where('product_name',$product);
           
            //$ci->db->where('emp_id',$system);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->id;
    }   


}


if ( ! function_exists('date_time'))
{
    function date_time()
    {
    	//date_default_timezone_set('America/Chicago');
    	date_default_timezone_set('Asia/Karachi');
		$date = date("Y-m-d");
		$time = date("h:i:sa");
		$datetime = array('date'=>$date,'time'=>$time);
    	return $datetime;
    }   
}
if ( ! function_exists('datetimeData'))
{
    function datetimeData($dt_id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('datetime',array('dt_id'=>$dt_id));
    	return $query->result_array();
	}   
}

if ( ! function_exists('user_data'))
{
    function user_data($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('users',array('u_id'=>$id));
    	return $query->result_array();
    }   
}


if ( ! function_exists('User_Name'))
{
    function User_Name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('users',array('id'=>$id));
         if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('get_last'))
{
    function get_last($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('product_id',$id);
         $ci->db->where('insert_date',$date);
         $ci->db->where('moving_to',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_last_material'))
{
    function get_last_material($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('material_id',$id);
         $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}




if ( ! function_exists('deliverd_qty'))
{
    function deliverd_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('sum(dc_record.qty) as total ');
         $ci->db->from('dc_record');
         $ci->db->where('so_id',$id);
        
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('count_ot'))
{
    function count_ot($emp_id,$month1,$year1)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('sum(ot_advance_emp.over_time) as total');
         $ci->db->from('ot_advance_emp');
          $ci->db->where('emp_id',$emp_id);
         $ci->db->where('MONTH(date)',$month1);
         $ci->db->where('YEAR(date)',$year1);
        
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('total_advance'))
{
    function total_advance($emp_id,$month1,$year1)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('sum(ot_advance_emp.advance) as total');
         $ci->db->from('ot_advance_emp');
         $ci->db->where('emp_id',$emp_id);
         $ci->db->where('MONTH(date)',$month1);
         $ci->db->where('YEAR(date)',$year1);
        
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('total_allowance'))
{
    function total_allowance($emp_id,$month1,$year1)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('SUM(ot_advance_emp.allowance) as total');
         $ci->db->from('ot_advance_emp');
         
         $ci->db->where('emp_id',$emp_id);
         $ci->db->where('MONTH(date)',$month1);
         $ci->db->where('YEAR(date)',$year1);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_last_packing'))
{
    function get_last_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('material_id',$id);
         $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}




if ( ! function_exists('get_last_color'))
{
    function get_last_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('color_id',$id);
         $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('get_last_all'))
{
    function get_last_all($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('product_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_last_all_material_pack'))
{
    function get_last_all_material_pack($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('material_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_last_all_material_color'))
{
    function get_last_all_material_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('color_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_out_all'))
{
    function get_out_all($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('product_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}




if ( ! function_exists('return_material'))
{
    function return_material($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(production_stock_return.r_qty) as total ');
         $ci->db->from('production_stock_return');
         $ci->db->where('machine_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_for_bom_type'))
{
    function get_for_bom_type($id)
    {
        $ci=& get_instance();
        $ci->load->database();
       // $query = $ci->db->get_where('products',array('id'=>$id));

        $ci->db->select('products.product_type');
         $ci->db->from('products');
         $ci->db->where('id',$id);
         $ci->db->where('product_type',1);
         //$ci->db->where('product_type !=',"");
        $query = $ci->db->get();


        if($query->num_rows()>0) return $query->first_row()->product_type;
    }   
}


if ( ! function_exists('last_balanace'))
{
    function last_balanace($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('production_stock_log.balance as total ');
         $ci->db->from('production_stock_log');
         $ci->db->where('machine_id',$id);
         $ci->db->order_by('production_stock_log.id','DESC');
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_out_all_pack'))
{
    function get_out_all_pack($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('material_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



    
    if ( ! function_exists('get_out_all_color'))
{
    function get_out_all_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('color_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('get_out_all_production'))
{
    function get_out_all_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out_production.qty) as total ');
         $ci->db->from('stock_out_production');
         $ci->db->where('material_id',$id);
         $ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('get_out_balance'))
{
    function get_out_balance($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('product_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_out_balance_packing'))
{
    function get_out_balance_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_out_balance_color'))
{
    function get_out_balance_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out.qty) as total ');
         $ci->db->from('stock_out');
         $ci->db->where('color_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_out_balance_return'))
{
    function get_out_balance_return($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(production_stock_return.qty) as total ');
         $ci->db->from('production_stock_return');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_out_balance_raw'))
{
    function get_out_balance_raw($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(stock_out_production.qty) as total ');
         $ci->db->from('stock_out_production');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}




if ( ! function_exists('get_out_balance_compund'))
{
    function get_out_balance_compund($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(production_compund_stock_out.qty) as total ');
         $ci->db->from('production_compund_stock_out');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}





if ( ! function_exists('get_out_balance_wast'))
{
    function get_out_balance_wast($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(waste_out_stock.qty) as total ');
         $ci->db->from('waste_out_stock');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_out_balance_compund_Waste'))
{
    function get_out_balance_compund_Waste($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(production_compund_stock_out.qty_wast) as total ');
         $ci->db->from('production_compund_stock_out');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_in_balance'))
{
    function get_in_balance($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('product_id',$id);
         // $ci->db->where('moving_to',0);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_in_balance_packing'))
{
    function get_in_balance_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}




if ( ! function_exists('get_id_fg_product'))
{
    function get_id_fg_product($pro_name)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('products.name');
         $ci->db->from('products');
         $ci->db->where('name',$pro_name);
         $ci->db->where('product_type',5);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('get_in_balance_wast'))
{
    function get_in_balance_wast($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(waste_in_stock_log.qty) as total ');
         $ci->db->from('waste_in_stock_log');
         $ci->db->where('material_id',$id);
         //$ci->db->where('insert_date !=',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_in_balance_color'))
{
    function get_in_balance_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
    
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('color_id',$id);
      
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_in_balance_return'))
{
    function get_in_balance_return($id)
    {
        $ci=& get_instance();
        $ci->load->database();
    
         $ci->db->select('sum(production_stock_log.qty) as total ');
         $ci->db->from('production_stock_log');
         $ci->db->where('material_id',$id);
      
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_last_created_date'))
{
    function get_last_created_date($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('in_stock_log.created');
       $ci->db->from('in_stock_log');
       $ci->db->where('product_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}



if ( ! function_exists('get_last_created_date_packing'))
{
    function get_last_created_date_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('in_stock_log.created');
       $ci->db->from('in_stock_log');
       $ci->db->where('material_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}


if ( ! function_exists('get_last_created_date_color'))
{
    function get_last_created_date_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('in_stock_log.created');
       $ci->db->from('in_stock_log');
       $ci->db->where('color_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}


if ( ! function_exists('get_last_created_date_out'))
{
    function get_last_created_date_out($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('stock_out.created');
       $ci->db->from('stock_out');
       $ci->db->where('product_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}



if ( ! function_exists('get_last_created_date_out_packing'))
{
    function get_last_created_date_out_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('stock_out.created');
       $ci->db->from('stock_out');
       $ci->db->where('material_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}





if ( ! function_exists('inout_emp_name'))
{
    function inout_emp_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('tap_in_out.emp_id');
       $ci->db->from('tap_in_out');
       $ci->db->where('id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->emp_id;
    }   
}



if ( ! function_exists('check_allowance'))
{
    function check_allowance($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('empolyees.allowance');
       $ci->db->from('empolyees');
       $ci->db->where('id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->allowance;
    }   
}



if ( ! function_exists('get_last_created_date_out_color'))
{
    function get_last_created_date_out_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('stock_out.created');
       $ci->db->from('stock_out');
       $ci->db->where('color_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}

if ( ! function_exists('get_out'))
{
    function get_out($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('sum(stock_out.qty) as totals');
       $ci->db->from('stock_out');
       $ci->db->where('product_id',$id);
       $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->totals;
    }   
}



if ( ! function_exists('get_out_packing'))
{
    function get_out_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('sum(stock_out.qty) as totals');
       $ci->db->from('stock_out');
       $ci->db->where('material_id',$id);
       $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->totals;
    }   
}



if ( ! function_exists('get_out_color'))
{
    function get_out_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('sum(stock_out.qty) as totals');
       $ci->db->from('stock_out');
       $ci->db->where('color_id',$id);
       $ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->totals;
    }   
}


if ( ! function_exists('get_material_type'))
{
    function get_material_type($nature)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('material_type',array('id'=>$nature));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('get_nature_name'))
{
    function get_nature_name($nature)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('business_nature',array('id'=>$nature));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('customers'))
{
    function customers($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('customers',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('pur_log_qty'))
{
    function pur_log_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_log',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}




if ( ! function_exists('production_machine_id'))
{
    function production_machine_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_machine_remarks',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->machine;
    }   
}
    

   /* if ( ! function_exists('production_machine_id_so_id'))
{
    function production_machine_id_so_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_machine_remarks',array('machine'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}*/

    if ( ! function_exists('production_machine_id_so_id'))
{
    function production_machine_id_so_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('product_id');
       $ci->db->from('production_machine_remarks');
       $ci->db->where('machine',$id);
       $ci->db->where('status',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}

if ( ! function_exists('production_so_id'))
{
    function production_so_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('so_id');
       $ci->db->from('production_machine_remarks');
       $ci->db->where('machine',$id);
       $ci->db->where('status',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}


if ( ! function_exists('production_machine_id_so_id_supervisor1'))
{
    function production_machine_id_so_id_supervisor1($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select('product_id');
       $ci->db->from('production_machine_remarks');
       $ci->db->where('machine',$id);
       $ci->db->where('status',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}



if ( ! function_exists('pur_log_product'))
{
    function pur_log_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_log',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}


if ( ! function_exists('get_total_qty'))
{
    function get_total_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order',array('product_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}



if ( ! function_exists('get_unit_name'))
{
    function get_unit_name($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('units',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->names;
    }   
}


if ( ! function_exists('inspect_item'))
{
    function inspect_item($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->child_product;
    }   
}



if ( ! function_exists('inspect_mat'))
{
    function inspect_mat($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}

if ( ! function_exists('get_ins_pro'))
{
    function get_ins_pro($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('get_ins_mat'))
{
    function get_ins_mat($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('get_product_type'))
{
    function get_product_type($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('product_type',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('get_child_pro_type'))
{
    function get_child_pro_type($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_type;
    }   
}



if ( ! function_exists('ref_no_para'))
{
    function ref_no_para($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_parameter_ref_no',array('mold_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->ref_no;
    }   
}


if ( ! function_exists('item_production_ins'))
{
    function item_production_ins($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('mold'=>$id));
        if($query->num_rows()>0) return $query->first_row()->child_id;
    }   
}

if ( ! function_exists('get_bom_pro_id'))
{
    function get_bom_pro_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->child_product;
    }   
}


if ( ! function_exists('sale_order_pro'))
{
    function sale_order_pro($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}




if ( ! function_exists('so_req_qty'))
{
    function so_req_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->quantity;
    }   
}


if ( ! function_exists('so_req_job'))
{
   function so_req_job($id,$pro)
    {
        $ci=& get_instance();
        $ci->load->database();
        $ci->db->select('job');
        $ci->db->from('production_plan');
        $ci->db->where('so_id',$id);
        $ci->db->where('product_name',$pro);
        $ci->db->order_by('job','DESC');
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->job;
    } 
}


if ( ! function_exists('check_in_batch'))
{
   function check_in_batch($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $ci->db->select('so_id');
        $ci->db->from('release_batch');
        $ci->db->where('so_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->so_id;
    } 
}


if ( ! function_exists('sale_order_proref'))
{
    function sale_order_proref($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->ref_code;
    }   
}



if ( ! function_exists('get_pro_id'))
{
    function get_pro_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('name'=>$id));
        if($query->num_rows()>0) return $query->first_row()->id;
    }   
}


if ( ! function_exists('so_po_boms_ids'))
{
    function so_po_boms_ids($product_id,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('id');
         $ci->db->from('so_po_boms');
          $ci->db->where('main_product',$product_id);
          $ci->db->where('so_id',$so_id);
        
        $query = $ci->db->get();
        //print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->id;
    }   
}



/*if ( ! function_exists('so_delivery_date'))
{
    function so_delivery_date($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->delv_date;
    }   
}*/


if ( ! function_exists('so_delivery_date'))
{
    function so_delivery_date($id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
          $ci->db->select('delv_date');
          $ci->db->from('sales_order_products');
          $ci->db->where('so_id',$id);
          //$ci->db->order_by("delv_date","DESC");
        
        $query = $ci->db->get();
        //print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->delv_date;
    }   
}



if ( ! function_exists('so_number_dc'))
{
    function so_number_dc($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_no;
    }   
}



if ( ! function_exists('get_party_address'))
{
    function get_party_address($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->party_id;
    }   
}



if ( ! function_exists('qty_so'))
{
    function qty_so($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->quantity;
    }   
}


if ( ! function_exists('bank_name'))
{
    function bank_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('banks',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->bank;
    }   
}


if ( ! function_exists('party_name'))
{
    function party_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('qty_so_tolorence'))
{
    function qty_so_tolorence($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->total_qty;
    }   
}



if ( ! function_exists('tolerence'))
{
    function tolerence($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->tolerance;
    }   
}



if ( ! function_exists('po_number'))
{
    function po_number($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->po_no;
    }   
}


if ( ! function_exists('bom_fsg_pro'))
{
    function bom_fsg_pro($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('get_bom_product_id'))
{
    function get_bom_product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->child_product;
    }   
}


if ( ! function_exists('salary_emp'))
{
    function salary_emp($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('empolyees',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->salary;
    }   
}


if ( ! function_exists('material_name'))
{
    function material_name($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('materials',array('id'=>$id));
    	if($query->num_rows()>0) return $query->first_row()->name;
    }   
}



if ( ! function_exists('material_grade'))
{
    function material_grade($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->grade;
    }   
}



if ( ! function_exists('color_name'))
{
    function color_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_color',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}



if ( ! function_exists('fullname'))
{
    function fullname($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->fullname;
    }   
}




if ( ! function_exists('depart_emp'))
{
    function depart_emp($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('empolyees',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->depart;
    }   
}

if ( ! function_exists('main_so_po_id'))
{
    function main_so_po_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_po_id;
    }   
}


if ( ! function_exists('get_material_id'))
{
    function get_material_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}


if ( ! function_exists('color_mat'))
{
    function color_mat($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->color;
    }   
}



if ( ! function_exists('product_name'))
{
    function product_name($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	//$query = $ci->db->get_where('products',array('id'=>$id));
    	 $ci->db->select('name');
         $ci->db->from('products');
         $ci->db->where('id',$id);
          
        $query = $ci->db->get();
       // print_r($ci->db->last_query($query));   
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}


if ( ! function_exists('product_code'))
{
    function product_code($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->pro_code;
    }   
}




if ( ! function_exists('code_description'))
{
    function code_description($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('company_description',array('fg_ref_id'=>$id));
        return $query->first_row()->description;

        // $ci->db->select('*');
        //  $ci->db->from('fg_rates');
        //  //$ci->db->join('fg_rates','company_description.fg_ref_id = fg_rates.id');
        //  $ci->db->where('fg_rates.product',$id);
        //  $ci->db->where('fg_rates.status',1);
        // $query = $ci->db->get();
        // //print_r($ci->db->last_query($query));   die;
        // if($query->num_rows()>0) return $query->first_row()->id;
    }   
}




if ( ! function_exists('product_ref_code'))
{
    function product_ref_code($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->ref_no;
    }   
}


if ( ! function_exists('product_color'))
{
    function product_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->ref_no;
    }   
}

if ( ! function_exists('product_weight'))
{
    function product_weight($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->weight;
    }   
}

if ( ! function_exists('product_code'))
{
function product_code($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	return $query->first_row()->pro_code;
    }   
}


if ( ! function_exists('product_remark'))
{
function product_remark($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->remarks;
    }   
}


if ( ! function_exists('material_make'))
{
function material_make($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('materials',array('id'=>$id));
    	return $query->first_row()->make;
    }   
}

if ( ! function_exists('material_garde'))
{
function material_garde($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        return $query->first_row()->grade;
    }   
}


if ( ! function_exists('material_codess'))
{
    function material_codess($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_code;
    }   
}


if ( ! function_exists('depart'))
{
    function depart($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('department',array('id'=>$id));
    	return $query->first_row()->depart;
    }   
}


if ( ! function_exists('bom_product'))
{
    function bom_product($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('products',array('id'=>$id));
    	return $query->first_row()->name;
    }   
}


if ( ! function_exists('vendor'))
{
    function vendor($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('vendors',array('id'=>$id));
    	return $query->first_row()->vendor_name;
    }   
}

if ( ! function_exists('vendor_code'))
{
    function vendor_code($id)
    {
    	$ci=& get_instance();
    	$ci->load->database();
    	$query = $ci->db->get_where('vendors',array('id'=>$id));
    	return $query->first_row()->code;
    }   
}



if ( ! function_exists('mat_id'))
{
    function mat_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('id'=>$id));
        return $query->first_row()->material_id;
    }   
}

if ( ! function_exists('pro_id'))
{
    function pro_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('id'=>$id));
        return $query->first_row()->product_id;
    }   
}



if ( ! function_exists('attn'))
{
    function attn($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->attn;
    }   
}


if ( ! function_exists('addres_vendor'))
{
    function addres_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->address;
    }   
}



if ( ! function_exists('email_vendor'))
{
    function email_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->email;
    }   
}

if ( ! function_exists('phone_vendor'))
{
    function phone_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('vendors',array('id'=>$id));
        return $query->first_row()->phone;
    }   
}


if ( ! function_exists('material_type_po'))
{
    function material_type_po($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->type;
    }   
}


if ( ! function_exists('dc_weight'))
{
    function dc_weight($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->weight;
    }   
}


if ( ! function_exists('po_dashboard_qty'))
{
    function po_dashboard_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->order_qty;
    }   
}


if ( ! function_exists('partyname'))
{
    function partyname($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->name;
    }   
}

if ( ! function_exists('partystrn'))
{
    function partystrn($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->strn;
    }   
}



if ( ! function_exists('partyntn'))
{
    function partyntn($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->ntn;
    }   
}


if ( ! function_exists('addres_party'))
{
    function addres_party($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->address;
    }   
}




if ( ! function_exists('email_party'))
{
    function email_party($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('parties',array('p_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->email;
    }   
}
    

 
    


if ( ! function_exists('dc_weight_pro'))
{
    function dc_weight_pro($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->weight;
    }   
}


if ( ! function_exists('requisition_type'))
{
    function requisition_type($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->type;
    }   
}


if ( ! function_exists('po_vendor'))
{
    function po_vendor($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order',array('id'=>$id));
        return $query->first_row()->vendor_id;
    }   
}



if ( ! function_exists('mold_name'))
{
    function mold_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('id'=>$id));
        return $query->first_row()->product_id;
    }   
}



if ( ! function_exists('mold_product'))
{
    function mold_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('product_id'=>$id));
        return $query->first_row()->code;
    }   
}


if ( ! function_exists('mold_product_id'))
{
    function mold_product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('product_id'=>$id));
        return $query->first_row()->id;
    }   
}



if ( ! function_exists('mold_code'))
{
    function mold_code($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('id'=>$id));
        return $query->first_row()->code;
    }   
}




if ( ! function_exists('get_mold_id'))
{
    function get_mold_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('molds',array('product_id'=>$id));
        return $query->first_row()->id;
    }   
}




if ( ! function_exists('machine_name'))
{
    function machine_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->machine_name;
    }   
}


if ( ! function_exists('electricity_consumed'))
{
    function electricity_consumed($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->electricity_consume;
    }   
}




if ( ! function_exists('machine_cost_hr'))
{
    function machine_cost_hr($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->machine_cost_day;
    }   
}

if ( ! function_exists('machine_unit'))
{
    function machine_unit($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->electricity_consume;
    }   
}



if ( ! function_exists('machine_dep_amount'))
{
    function machine_dep_amount($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->dept_cost_hrs;
    }   
}


if ( ! function_exists('md_profit'))
{
    function md_profit($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        return $query->first_row()->md_profit;
    }   
}


if ( ! function_exists('qc_machine_get_machine_id'))
{
    function qc_machine_get_machine_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->machine_id;
    }   
}



if ( ! function_exists('product_id'))
{
    function product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('name'=>$id));
        return $query->first_row()->id;
    }   
}


if ( ! function_exists('material_id'))
{
    function material_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('materials',array('name'=>$id));
        return $query->first_row()->id;
    }   
}



if ( ! function_exists('production_unit'))
{
    function production_unit($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('id'=>$id));
        return $query->first_row()->bom_unit;
    }   
}

 
 if ( ! function_exists('unit_production_color'))
{
    function unit_production_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('id'=>$id));
        return $query->first_row()->bom_unit_color;
    }   
}


    if ( ! function_exists('qty_production'))
{
    function qty_production($p_name,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       
         $ci->db->select('p_qty');
         $ci->db->from('production_plan');
        
          //$ci->db->where('so_id',$so_id);
           $ci->db->where('product_name',$p_name);

            $ci->db->where('so_id',$so_id);
        $query = $ci->db->get();
        //print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->p_qty;
    } 

}


if ( ! function_exists('qty_in_stock_log'))
{
    function qty_in_stock_log($product_id,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       // $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(in_stock_log.qty) as total ');
         $ci->db->from('in_stock_log');
         $ci->db->where('so_id',$so_id);
         $ci->db->where('product_id',$product_id);
         //$ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('bill_pay_amount'))
{
    function bill_pay_amount($so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(bill_payment.amount) as paid_amount ');
         $ci->db->from('bill_payment');
         $ci->db->where('so_id',$so_id);
         //$ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->paid_amount;
    }   
}


if ( ! function_exists('get_mat_totalqty'))
{
    function get_mat_totalqty($material_id)
    {
        $ci=& get_instance();
        $ci->load->database();
       // $date = date('Y-m-d');
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
         $ci->db->select('sum(purchase_order_materials_details.order_qty) as total ');
         $ci->db->from('purchase_order_materials_details');
         $ci->db->join('purchase_order','purchase_order.id = purchase_order_materials_details.po_id');
         $ci->db->where('purchase_order.po_date >=','2022-08-06');
         //$this->db->where('purchase_order.id',$id);

         $ci->db->where('material_id',$material_id);

         //$ci->db->where('insert_date',$date);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('get_material_from_production'))
{
    function get_material_from_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('id'=>$id));
        return $query->first_row()->material_id;
    }   
}



if ( ! function_exists('machine_from_production'))
{
    function machine_from_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_machine_remarks',array('so_id'=>$id));
        return $query->first_row()->machine;
    }   
}

/*if ( ! function_exists('qc_machine_get_product_id'))
{
    function qc_machine_get_product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('products',array('id'=>$id));
        return $query->first_row()->product_id;
    }   
}*/

if ( ! function_exists('qc_machine_get_product_id'))
{
    function qc_machine_get_product_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->product_id;
    }   
}


if ( ! function_exists('qc_machine_get_material_id'))
{
    function qc_machine_get_material_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->material_id;
    }   
}




if ( ! function_exists('get_job_from_qcmachine'))
{
    function get_job_from_qcmachine($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->job;
    }   
}



if ( ! function_exists('qc_machine_get_mold_pr'))
{
    function qc_machine_get_mold_pr($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->mr_mould;
    }   
}



if ( ! function_exists('qc_machine_get_pc_cavity'))
{
    function qc_machine_get_pc_cavity($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->pcs_cavity;
    }   
}

if ( ! function_exists('qc_machine_get_pc_weight'))
{
    function qc_machine_get_pc_weight($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        return $query->first_row()->weight;
    }   
}



if ( ! function_exists('get_log_stock_pro'))
{
    function get_log_stock_pro($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('in_stock_log',array('id'=>$id));
        return $query->first_row()->product_id;
    }   
}




if ( ! function_exists('get_log_stock_mat'))
{
    function get_log_stock_mat($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('in_stock_log',array('id'=>$id));
        return $query->first_row()->material_id;
    }   
}



if ( ! function_exists('get_log_stock_color'))
{
    function get_log_stock_color($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('in_stock_log',array('id'=>$id));
        return $query->first_row()->color_id;
    }   
}

if ( ! function_exists('get_log_stock_wast'))
{
    function get_log_stock_wast($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('waste_in_stock_log',array('id'=>$id));
        return $query->first_row()->material_id;
    }   
}
    
if ( ! function_exists('log_qty'))
{
    function log_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('in_stock_log',array('id'=>$id));
        return $query->first_row()->qty;
    }   
}

if ( ! function_exists('waste_log_qty'))
{
    function waste_log_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('waste_in_stock_log',array('id'=>$id));
        return $query->first_row()->qty;
    }   
}


if ( ! function_exists('color_name'))
{
    function color_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_color',array('id'=>$id));
        return $query->first_row()->name;
    }   
}




if ( ! function_exists('clerence_match'))
{
    function clerence_match($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select(' line_clerence.production_id as production_id_clear');
       $ci->db->from(' line_clerence');
       $ci->db->where('production_id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->production_id_clear;
    }   
}



if ( ! function_exists('get_runing_machine'))
{
    function get_runing_machine($so_id,$product)
    {
        $ci=& get_instance();
        $ci->load->database();
        //$query = $ci->db->get_where('in_stock_log',array('product_id'=>$id));
       $ci->db->select(' production_machine_remarks.machine');
       $ci->db->from(' production_machine_remarks');
       $ci->db->where('so_id',$so_id);
       $ci->db->where('product_id',$product);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->machine;
    }   
}




if ( ! function_exists('condition_check_line'))
{
    function condition_check_line($so_id,$p_id)
    {
      /* $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('line_clerence',array('so_id'=>$id));*/
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('so_id');
         $ci->db->from('line_clerence');
         $ci->db->where('so_id',$so_id);
         $ci->db->where('product_id',$p_id);
          $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}


if ( ! function_exists('production_get_id'))
{
    function production_get_id($job)
    {
        $ci=& get_instance();
        $ci->load->database();
        $ci->db->select(' production_plan.id');
        $ci->db->from(' production_plan');
        $ci->db->where('job',$job);
        //$ci->db->where('complete_status',0);
        $query = $ci->db->get();

        if($query->num_rows()>0) return $query->first_row()->id;
    }   
}


if ( ! function_exists('production_get_so_id'))
{
    function production_get_so_id($job)
    {
        $ci=& get_instance();
        $ci->load->database();
        $ci->db->select(' production_plan.so_id');
        $ci->db->from(' production_plan');
        $ci->db->where('job',$job);
        //$ci->db->where('complete_status',0);
        $query = $ci->db->get();

        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}



if ( ! function_exists('get_so_product'))
{
    function get_so_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        return $query->first_row()->product_id;
    }   
}


if ( ! function_exists('so_number'))
{
    function so_number($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_no;
    }   
}


if ( ! function_exists('day_night'))
{
    function day_night($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_machine',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->day_night;
    }   
}



if ( ! function_exists('machine_compound'))
{
    function machine_compound($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('insert_date'=>$id));
        if($query->num_rows()>0) return $query->first_row()->machine_id;
    }   
}



if ( ! function_exists('condition_injection_blow'))
{
    function condition_injection_blow($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->machine_type;
    }   
}




if ( ! function_exists('machine_type_ibm'))
{
    function machine_type_ibm($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('machines',array('id'=>$id));
        //print_r($ci->db->last_query($query));   die;
        if($query->num_rows()>0) return $query->first_row()->machine_type;
    }   
}


if ( ! function_exists('po_material'))
{
    function po_material($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}


if ( ! function_exists('po_product'))
{
    function po_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('purchase_order_materials_details',array('po_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}





if ( ! function_exists('gst_apply'))
{
    function gst_apply($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order_products',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->gst;
    }   
}

if ( ! function_exists('so_party_id'))
{
    function so_party_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sales_order',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->party_id;
    }   
}

if( ! function_exists('number_to_words')){

    function number_to_words($number){
  // Define arrays for words
  $ones = array("", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine");
  $teens = array("", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen");
  $tens = array("", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety");

  $thousands = array("", "thousand", "million", "billion", "trillion");

  if ($number == 0) {
      return "zero";
  } else {
      $word = "";
      $chunkCount = 0;
      while ($number > 0) {
          $chunk = $number % 1000;
          if ($chunk != 0) {
              $words = "";
              if ($chunk >= 100) {
                  $words .= $ones[floor($chunk / 100)] . " hundred ";
              }
              if ($chunk % 100 >= 11 && $chunk % 100 <= 19) {
                  $words .= $teens[$chunk % 100 - 10] . " ";
              } else {
                  if ($chunk % 100 >= 20) {
                      $words .= $tens[floor($chunk % 100 / 10)] . " ";
                  }
                  if ($chunk % 10 > 0) {
                      $words .= $ones[$chunk % 10] . " ";
                  }
              }
              $words .= $thousands[$chunkCount] . " ";
              $word = $words . $word;
          }
          $number = floor($number / 1000);
          $chunkCount++;
      }
      return trim($word);
  }
   }
}

if ( ! function_exists('check_so_for_bom'))
{
    function check_so_for_bom($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('so_po_boms',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->id;
    }   
}




if ( ! function_exists('sopoboms_id_get_so_id'))
{
    function sopoboms_id_get_so_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('so_po_boms',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}




if ( ! function_exists('so_get_pro'))
{
    function so_get_pro($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('so_po_boms',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->main_product;
    }   
}

if ( ! function_exists('so_get_so_id'))
{
    function so_get_so_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('so_po_boms',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}



if ( ! function_exists('get_bom_requir_productoin'))
{
    function get_bom_requir_productoin($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->bom_qty;
    }   
}



if ( ! function_exists('get_production_material'))
{
    function get_production_material($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}




if ( ! function_exists('getbom_qty'))
{
    function getbom_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('puchase_order_details',array('material_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('get_so_production'))
{
    function get_so_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}


if ( ! function_exists('get_product_production'))
{
    function get_product_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_name;
    }   
}


if ( ! function_exists('get_material_production'))
{
    function get_material_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}

if ( ! function_exists('get_machine_production'))
{
    function get_machine_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->machine_id;
    }   
}


if ( ! function_exists('get_qcr_production'))
{
    function get_qcr_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qcr;
    }   
}

if ( ! function_exists('get_color_production'))
{
    function get_color_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->color_code;
    }   
}


if ( ! function_exists('get_ratio_production'))
{
    function get_ratio_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->color_ratio;
    }   
}


/*if ( ! function_exists('get_qty_production'))
{
    function get_qty_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}*/


if ( ! function_exists('get_qty_production'))
{
    function get_qty_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(stock_out_production.qty) as total ');
         $ci->db->from('stock_out_production');
         $ci->db->where('production_id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}




if ( ! function_exists('total_assemble'))
{
    function total_assemble($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(assembled_line.qty) as total ');
         $ci->db->from('assembled_line');
         $ci->db->where('id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('total_assembled_log'))
{
    function total_assembled_log($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(assembled_line_log.qty) as total ');
         $ci->db->from('assembled_line_log');
         $ci->db->where('assembled_id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}



if ( ! function_exists('total_sealed'))
{
    function total_sealed($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(sealed_line.qty) as total ');
         $ci->db->from('sealed_line');
         $ci->db->where('id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('total_sealed_log'))
{
    function total_sealed_log($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(sealed_line_log.qty) as total ');
         $ci->db->from('sealed_line_log');
         $ci->db->where('sealed_id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('total_packing'))
{
    function total_packing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(fg_line.qty) as total ');
         $ci->db->from('fg_line');
         $ci->db->where('id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('total_packing_log'))
{
    function total_packing_log($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(fg_line_log.qty) as total ');
         $ci->db->from('fg_line_log');
         $ci->db->where('packing_id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('total_printing'))
{
    function total_printing($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(printed_line.qty) as total ');
         $ci->db->from('printed_line');
         $ci->db->where('id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}


if ( ! function_exists('total_printing_log'))
{
    function total_printing_log($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('sum(printing_line_log.qty) as total ');
         $ci->db->from('printing_line_log');
         $ci->db->where('printing_id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->total;
    }   
}

if ( ! function_exists('get_create_production'))
{
    function get_create_production($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('stock_out_production',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->created;
    }   
}



if ( ! function_exists('assemble_status'))
{
    function assemble_status($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('assembled_line',array('batch'=>$id));
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}


if ( ! function_exists('sealing_status'))
{
    function sealing_status($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sealed_line',array('batch'=>$id));
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}

if ( ! function_exists('printed_status'))
{
    function printed_status($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('printed_line',array('batch'=>$id));
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}


if ( ! function_exists('packing_status'))
{
    function packing_status($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_line',array('batch'=>$id));
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}





if ( ! function_exists('get_fg_id'))
{
    function get_fg_id($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_line',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->fg_product;
    }   
}


if ( ! function_exists('batch_get_batchno'))
{
    function batch_get_batchno($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('fg_line',array('id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->batch;
    }   
}



if ( ! function_exists('batch_condition'))
{
    function batch_condition($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('assembled_line',array('batch'=>$id));
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}


if ( ! function_exists('batch_condition_sealed'))
{
    function batch_condition_sealed($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('sealed_line',array('batch'=>$id));
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}


if ( ! function_exists('in_bom'))
{
    function in_bom($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('boms',array('main_product'=>$id));
        if($query->num_rows()>0) return $query->first_row()->main_product;
    }   
}


if ( ! function_exists('get_machine_production_from_machine_remarks'))
{
    function get_machine_production_from_machine_remarks($so_id,$p_id)
    {
        /*$ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_machine_remarks',array('so_id'=>$id));
*/      
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('machine');
         $ci->db->from('production_machine_remarks');
         $ci->db->where('so_id',$so_id);
         $ci->db->where('product_id',$p_id);
   $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->machine;
    }   
}


if ( ! function_exists('get_so_frominspection'))
{
    function get_so_frominspection($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_parameter_samples',array('production_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}



/*if ( ! function_exists('check_idininspection'))
{
    function check_idininspection($so_id,$product_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('qc_parameter_samples',array('so_id'=>$id));
        if($query->num_rows()>0) return $query->first_row()->so_id;
    }   
}*/


if ( ! function_exists('check_idininspection'))
{
    function check_idininspection($so_id,$product_id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('product_id');
         $ci->db->from('qc_parameter_samples');
         $ci->db->where('so_id',$so_id);
         $ci->db->where('product_id',$product_id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->product_id;
    }   
}



if ( ! function_exists('product_insepect'))
{
    function product_insepect($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('product_name'=>$id));
        if($query->num_rows()>0) return $query->first_row()->product_name;
    }   
}


/*if ( ! function_exists('product_match'))
{
    function product_match($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('product_name'=>$id));
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}*/


if ( ! function_exists('product_match'))
{
    function product_match($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('material_id');
         $ci->db->from('production_plan');
         $ci->db->where('product_name',$id);
         $ci->db->where('complete_status',0);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->material_id;
    }   
}


if ( ! function_exists('product_match_job'))
{
    function product_match_job($id,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('product_name'=>$id,'so_id'=>$so_id));
        if($query->num_rows()>0) return $query->first_row()->job;
    }   
}


if ( ! function_exists('last_job'))
{
    function last_job($so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('so_id'=>$so_id));
        $ci->db->order_by('id','DESC');
        if($query->num_rows()>0) return $query->first_row()->job;
    }   
}


if ( ! function_exists('product_match_color_id'))
{
    function product_match_color_id($id,$so_id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('production_plan',array('product_name'=>$id,'so_id'=>$so_id));
        if($query->num_rows()>0) return $query->first_row()->color_id;
    }   
}



if ( ! function_exists('batch_no'))
{
    function batch_no($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->batch;
    }   
}


if ( ! function_exists('printing_machine_name'))
{
    function printing_machine_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('other_machine',array('id'=>$id));
        return $query->first_row()->name;
    }   
}


if ( ! function_exists('batch_product'))
{
    function batch_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->product;
    }   
}

if ( ! function_exists('printing_product'))
{
    function printing_product($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->printing_product;
    }   
}

if ( ! function_exists('batch_product_main'))
{
    function batch_product_main($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->main_product;
    }   
}


if ( ! function_exists('batch_product_ass'))
{
    function batch_product_ass($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->printing_product;
        
    }   
}


if ( ! function_exists('batch_no'))
{
    function batch_no($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->batch;
    }   
}

if ( ! function_exists('batch_product_sealed'))
{
    function batch_product_sealed($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('transform');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('type',4);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->transform;
    }   
}



if ( ! function_exists('batch_product_assembled'))
{
    function batch_product_assembled($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('transform');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('type',3);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->transform;
    }   
}

if ( ! function_exists('batch_product_FG'))
{
    function batch_product_FG($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->main_product;
    }   
}


if ( ! function_exists('batch_qty'))
{
    function batch_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('release_batch',array('id'=>$id));
        return $query->first_row()->qty;
    }   
}



if ( ! function_exists('batch_size'))
{
    function batch_size($id)
    {
       
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(batch_size) as batch_size');
         $ci->db->from('batch_assign_to_batch_size');
         $ci->db->where('so_id',$id);
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->batch_size;
    }   
}




if ( ! function_exists('check_status_release'))
{
    function check_status_release($id)
    {
       
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('status');
         $ci->db->from('release_batch');
         $ci->db->where('so_id',$id);
         $ci->db->group_by('so_id');
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->status;
    }   
}



if ( ! function_exists('remaining_blance'))
{
    function remaining_blance($id)
    {
       
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('batch_size');
         $ci->db->from('release_batch');
         $ci->db->where('so_id',$id);
         $ci->db->group_by('so_id');
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->batch_size;
    }   
}


if ( ! function_exists('get_transform_qty'))
{
    function get_transform_qty($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('qty as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}



if ( ! function_exists('get_transform_qty_printing'))
{
    function get_transform_qty_printing($id,$pro_batch_printing)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro_batch_printing);
         $ci->db->where('type',3);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}


if ( ! function_exists('packing_fg'))
{
    function packing_fg($id,$pro_batch_printing)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro_batch_printing);
         $ci->db->where('type',6);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}


if ( ! function_exists('get_transform_qty_sealing'))
{
    function get_transform_qty_sealing($id,$pro_batch_printing)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro_batch_printing);
         $ci->db->where('type',5);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}



if ( ! function_exists('get_transform_qty_sealing'))
{
    function get_transform_qty_sealing($id,$pro_batch_printing)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro_batch_printing);
         $ci->db->where('type',4);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}


if ( ! function_exists('get_transform_qty_ass'))
{
    function get_transform_qty_ass($id,$pro)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro);
         $ci->db->where('type',3);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}


if ( ! function_exists('get_transform_qty_packing'))
{
    function get_transform_qty_packing($id,$pro)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro);
         $ci->db->where('type',5);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}

if ( ! function_exists('get_transform_qty_sealed'))
{
    function get_transform_qty_sealed($id,$pro)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         //$ci->db->where('batch',$id);
         $ci->db->where('transform',$pro);
         $ci->db->where('type',4);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}




if ( ! function_exists('pro_batch_printing'))
{
    function pro_batch_printing($id)
    {
         $ci=& get_instance();
         $ci->load->database();
         $ci->db->select('printing_product');
         $ci->db->from('release_batch');
         $ci->db->where('id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->printing_product;
    }   
}


if ( ! function_exists('pro_batch_packing'))
{
    function pro_batch_packing($id)
    {
         $ci=& get_instance();
         $ci->load->database();
         $ci->db->select('packing_product');
         $ci->db->from('release_batch');
         $ci->db->where('id',$id);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->packing_product;
    }   
}




if ( ! function_exists('pro_batch_sealing'))
{
    function pro_batch_sealing($id)
    {
         $ci=& get_instance();
         $ci->load->database();
         $ci->db->select('sealed_product');
         $ci->db->from('release_batch');
         $ci->db->where('batch',$id);
         $ci->db->group_by('batch');
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->sealed_product;
    }   
}



if ( ! function_exists('get_transform_qty_assebled'))
{
    function get_transform_qty_assebled($id,$pro)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('transform',$pro);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}



if ( ! function_exists('batch_qty_create'))
{
    function batch_qty_create($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('status',0);
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}


if ( ! function_exists('get_transform_qty_assembled'))
{
    function get_transform_qty_assembled($id)
    {
        $ci=& get_instance();
        $ci->load->database();
         $ci->db->select('SUM(qty) as qty');
         $ci->db->from('transform_logs');
         $ci->db->where('batch',$id);
         $ci->db->where('type','3');
         
        $query = $ci->db->get();
        if($query->num_rows()>0) return $query->first_row()->qty;
    }   
}




if ( ! function_exists('line_name'))
{
    function line_name($id)
    {
        $ci=& get_instance();
        $ci->load->database();
        $query = $ci->db->get_where('assembled_line',array('id'=>$id));
        return $query->first_row()->description;
    }   
}

	/* End Fatch Lease utilityes  */

